<?php

$video_dir = "user_videos"; 
$delete_after = 1; 

function endsWithCheck($needle, $haystack) {
     return preg_match('/' . preg_quote($needle, '/') . '$/', $haystack);
 }

if (file_exists($video_dir)) {
	$videos = scandir($video_dir);
	foreach ($videos as $idx => $video_name) {
		if ($video_name == "index.php")
		{
			continue;
		}
		if(!endsWithCheck(".mp4", $video_name))
		{
			continue;
		}
		$create_time = filemtime($video_dir . "/" . $video_name);
		if ((time() - $create_time) > $delete_after)
		{
			unlink($video_dir . "/" . $video_name);
		}
	}
}
