<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site Bakımda</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;500;700&display=swap');

        :root {
            --primary-color: #7289da;
            --secondary-color: #1e1e24;
            --accent-color: #00cec9;
            --text-color: #e0e0e0;
            --progress-color: #00b894;
            --background-color: #12121a;
            --container-color: #1f1f28;
            --shadow-color: rgba(0, 0, 0, 0.5);
            --danger-color: #e74c3c;
            --warning-color: #f39c12;
            --info-color: #3498db;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'DM Sans', sans-serif;
        }

        body {
            background-color: var(--background-color);
            color: var(--text-color);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .container {
            background: linear-gradient(145deg, var(--container-color), #1e293b);
            border-radius: 15px;
            box-shadow: 0 25px 50px -12px var(--shadow-color);
            padding: 40px;
            max-width: 800px;
            width: 100%;
            position: relative;
            overflow: hidden;
        }

        .icon-wrapper {
            text-align: center;
            margin-bottom: 30px;
        }

        .main-icon {
            font-size: 70px;
            color: var(--accent-color);
            margin-bottom: 20px;
        }

        h1 {
            font-size: 2.5rem;
            margin-bottom: 15px;
            color: var(--accent-color);
            font-weight: 700;
            text-align: center;
        }

        p {
            font-size: 1.2rem;
            margin-bottom: 25px;
            line-height: 1.6;
            color: var(--text-color);
            opacity: 0.9;
            text-align: center;
        }

        .progress-container {
            width: 100%;
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 50px;
            margin-bottom: 30px;
            overflow: hidden;
            height: 10px;
        }

        .progress-bar {
            height: 100%;
            background: linear-gradient(90deg, var(--progress-color), var(--accent-color));
            width: 30%;
            animation: progress 2s ease-in-out infinite;
        }

        @keyframes progress {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(300%); }
        }

        .countdown {
            font-size: 1.5rem;
            margin: 20px 0;
            color: var(--primary-color);
            font-weight: bold;
            text-align: center;
        }

        .updates-container {
            background-color: rgba(0, 0, 0, 0.2);
            border-radius: 10px;
            padding: 20px;
            margin: 30px 0;
            text-align: left;
            border-left: 4px solid var(--info-color);
        }

        .updates-container h3 {
            color: var(--info-color);
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .updates-container ul {
            list-style-type: none;
        }

        .updates-container ul li {
            margin-bottom: 10px;
            padding-left: 20px;
            position: relative;
        }

        .updates-container ul li::before {
            content: '•';
            position: absolute;
            left: 0;
            color: var(--info-color);
        }

        .support-container {
            background-color: rgba(0, 0, 0, 0.2);
            border-radius: 10px;
            padding: 20px;
            margin: 30px 0;
            text-align: center;
        }

        .support-container h3 {
            color: var(--primary-color);
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .support-email {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            margin-top: 10px;
            padding: 12px 24px;
            background-color: var(--primary-color);
            color: white;
            border-radius: 50px;
            font-weight: bold;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .support-email:hover {
            background-color: #5f73bc;
            transform: scale(1.05);
        }

        .social-icons {
            display: flex;
            justify-content: center;
            margin-top: 30px;
            gap: 20px;
        }

        .social-icons a {
            color: var(--text-color);
            font-size: 24px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .social-icons a:hover {
            color: var(--accent-color);
        }

        footer {
            margin-top: 40px;
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.5);
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="icon-wrapper">
            <i class="fas fa-tools main-icon"></i>
        </div>
        
        <h1 id="title">Sitemiz Bakım Aşamasında</h1>
        
        <p id="description">
            Sitemizi sizlere daha iyi hizmet verebilmek için yeniliyoruz. 
            Lütfen kısa bir süre sonra tekrar ziyaret edin.
        </p>
        
        <div class="progress-container">
            <div class="progress-bar"></div>
        </div>
        
        <div class="countdown" id="countdown">
            Kalan süre: <span id="time-remaining">--:--:--</span>
        </div>
        
        <div class="updates-container">
            <h3><i class="fas fa-info-circle"></i> Güncelleme Bilgisi</h3>
            <ul id="updates-list">
                <li>Sistemimiz şu anda güncelleniyor ve yeni özellikler ekleniyor.</li>
                <li>Veri tabanı optimizasyonu yapılıyor, bu işlem yaklaşık 2 saat sürecek.</li>
                <li>Yeni kullanıcı arayüzü tasarımı entegre ediliyor.</li>
                <li>Tüm sistem performans iyileştirmeleri yapılıyor.</li>
            </ul>
        </div>
        
        <div class="support-container">
            <h3><i class="fas fa-headset"></i> Destek mi lazım?</h3>
            <p>Bakım süresi boyunca herhangi bir sorunuz veya endişeniz varsa, lütfen bizimle iletişime geçmekten çekinmeyin.</p>
            <a href="mailto:destek@example.com" class="support-email" id="support-email">
                <i class="fas fa-envelope"></i> destek@example.com
            </a>
        </div>
        
        <div class="social-icons">
            <a href="#" target="_blank"><i class="fab fa-facebook"></i></a>
            <a href="#" target="_blank"><i class="fab fa-twitter"></i></a>
            <a href="#" target="_blank"><i class="fab fa-instagram"></i></a>
            <a href="#" target="_blank"><i class="fab fa-linkedin"></i></a>
        </div>
        
        <footer>
            &copy; <span id="current-year"></span> <span id="company-name">Şirket Adı</span> - Tüm Hakları Saklıdır
        </footer>
    </div>

    <script>
        // Config objesi
        const config = {
            title: "Sitemiz Bakım Aşamasında",
            description: "Sitemizi sizlere daha iyi hizmet verebilmek için yeniliyoruz. Lütfen kısa bir süre sonra tekrar ziyaret edin.",
            companyName: "Örnek Şirket",
            supportEmail: "destek@example.com",
        };

        // Başlangıç ve bitiş saatlerini belirle (Türkiye saatine göre)
        const startTime = new Date();
        startTime.setHours(04, 20, 0); // Örnek: Bugün 14:00:00 (UTC+3)
        const endTime = new Date();
        endTime.setHours(04, 25, 0); // Örnek: Bugün 18:00:00 (UTC+3)

        // Eğer başlangıç saati geçmişse, bitiş saatini bir sonraki güne ayarla
        if (startTime > new Date()) {
            startTime.setDate(startTime.getDate() + 1);
            endTime.setDate(endTime.getDate() + 1);
        }

        // Sayfa yüklendiğinde ayarları uygula
        document.addEventListener('DOMContentLoaded', function() {
            applyConfig();
            updateCountdown();
            setInterval(updateCountdown, 1000);
        });

        // Config ayarlarını sayfaya uygula
        function applyConfig() {
            document.getElementById('title').textContent = config.title;
            document.getElementById('description').textContent = config.description;
            document.getElementById('company-name').textContent = config.companyName;
            document.getElementById('support-email').textContent = config.supportEmail;
            document.getElementById('support-email').href = `mailto:${config.supportEmail}`;
            document.getElementById('current-year').textContent = new Date().getFullYear();
        }

        // Geri sayım zamanlayıcısını güncelle
        function updateCountdown() {
            const now = new Date();
            const remainingTime = endTime - now;

            if (remainingTime <= 0) {
                document.getElementById('time-remaining').textContent = "Tamamlandı!";
            } else {
                const hours = Math.floor(remainingTime / (1000 * 60 * 60));
                const minutes = Math.floor((remainingTime % (1000 * 60 * 60)) / (1000 * 60));
                const seconds = Math.floor((remainingTime % (1000 * 60)) / 1000);
                document.getElementById('time-remaining').textContent = 
                    `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
            }
        }
    </script>
</body>
</html>