<?php
// Oturumu başlat
session_start();

// Database bağlantısını yükle
require_once '../config/database.php';

// Oturum kontrolü
if (!isset($_SESSION['admin_id'])) {
    echo "<script>window.location.href = 'login.php';</script>";
    exit();
}

// Makaleleri getir
$sql = "SELECT * FROM articles ORDER BY created_at DESC";
$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Paneli - Makale Üretim Sistemi</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link href="../assets/css/admin.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container">
            <a class="navbar-brand" href="dashboard.php">
                <i class="fas fa-tachometer-alt"></i>Admin Paneli
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link active" href="dashboard.php">
                            <i class="fas fa-chart-bar"></i>Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="settings.php">
                            <i class="fas fa-cog"></i>Ayarlar
                        </a>
                    </li>
                </ul>
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="../index.php">
                            <i class="fas fa-home"></i>Ana Sayfa
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt"></i>Çıkış Yap
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card animate__animated animate__fadeIn">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5><i class="fas fa-file-alt"></i>Makaleler</h5>
                        <a href="../index.php" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus"></i>Yeni Makale Oluştur
                        </a>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Konu</th>
                                        <th>Anahtar Kelimeler</th>
                                        <th>Kelime Sayısı</th>
                                        <th>Oluşturulma Tarihi</th>
                                        <th>İşlemler</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($result->num_rows > 0): ?>
                                        <?php while($article = $result->fetch_assoc()): ?>
                                        <tr>
                                            <td><?php echo $article['id']; ?></td>
                                            <td><?php echo htmlspecialchars($article['topic']); ?></td>
                                            <td><?php echo htmlspecialchars($article['keywords']); ?></td>
                                            <td><?php echo $article['word_count']; ?></td>
                                            <td><?php echo date('d.m.Y H:i', strtotime($article['created_at'])); ?></td>
                                            <td>
                                                <a href="../preview.php?id=<?php echo $article['id']; ?>" class="btn btn-sm btn-info" title="Görüntüle">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="delete_article.php?id=<?php echo $article['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu makaleyi silmek istediğinizden emin misiniz?')" title="Sil">
                                                    <i class="fas fa-trash"></i>
                                                </a>
                                            </td>
                                        </tr>
                                        <?php endwhile; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="6" class="text-center py-4">
                                                <div class="text-muted">
                                                    <i class="fas fa-inbox fa-3x mb-3"></i>
                                                    <p>Henüz makale bulunmuyor</p>
                                                    <a href="../index.php" class="btn btn-sm btn-primary mt-2">
                                                        <i class="fas fa-plus"></i> Yeni Makale Oluştur
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // İkonlar için hover efekti
            $('.btn i, .nav-link i, .card-header h5 i').hover(
                function() {
                    $(this).addClass('animate__animated animate__heartBeat');
                },
                function() {
                    $(this).removeClass('animate__animated animate__heartBeat');
                }
            );
        });
    </script>
</body>
</html> 