<?php
require_once 'config/database.php';

$generated_article = null;
$error = null;

// API anahtarını veritabanından al
$sql = "SELECT setting_value FROM settings WHERE setting_key = 'gemini_api_key'";
$result = $conn->query($sql);
$api_key = $result->fetch_assoc()['setting_value'];

// Markdown işaretlerini temizlemek için yardımcı fonksiyon
function cleanMarkdown($text) {
    // Başlık işaretlerini temizle (# işaretleri)
    $text = preg_replace('/^#+\s+/m', '', $text);
    
    // Kalın ve italik işaretlerini temizle
    $text = preg_replace('/\*\*(.*?)\*\*/s', '$1', $text); // **kalın**
    $text = preg_replace('/\*(.*?)\*/s', '$1', $text);     // *italik*
    $text = preg_replace('/__(.*?)__/s', '$1', $text);     // __kalın__
    $text = preg_replace('/_(.*?)_/s', '$1', $text);       // _italik_
    
    // Liste işaretlerini temizle
    $text = preg_replace('/^\s*[\-\*\+]\s+/m', '• ', $text); // Liste öğeleri
    $text = preg_replace('/^\s*\d+\.\s+/m', '', $text);      // Numaralı listeler
    
    // Kod işaretlerini temizle
    $text = preg_replace('/`(.*?)`/s', '$1', $text);        // `kod`
    
    // Bağlantı işaretlerini temizle
    $text = preg_replace('/\[(.*?)\]\((.*?)\)/s', '$1', $text); // [metin](url)
    
    // > işaretlerini kaldır
    $text = preg_replace('/^\s*>\s+/m', '', $text);
    
    // Çizgileri temizle
    $text = preg_replace('/^-{3,}$/m', '', $text);
    
    return $text;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $topic = $_POST['topic'];
    $keywords = $_POST['keywords'];
    $wordCount = $_POST['wordCount'];
    
    // API isteği için gerekli verileri hazırla
    $data = [
        'contents' => [
            [
                'parts' => [
                    [
                        'text' => "Lütfen aşağıdaki konu hakkında {$wordCount} kelimelik bir makale yaz:\n\nKonu: {$topic}\nAnahtar Kelimeler: {$keywords}\n\nMakale Türkçe olmalı ve SEO dostu olmalıdır."
                    ]
                ]
            ]
        ]
    ];
    
    // API isteği gönder
    $ch = curl_init('https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent?key=' . $api_key);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $result = json_decode($response, true);
        
        // API yanıtını kontrol et
        if (isset($result['candidates'][0]['content']['parts'][0]['text'])) {
            $generated_article = $result['candidates'][0]['content']['parts'][0]['text'];
            
            // Makaleyi veritabanına kaydet
            $sql = "INSERT INTO articles (topic, keywords, content, word_count, created_at) VALUES (?, ?, ?, ?, NOW())";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("sssi", $topic, $keywords, $generated_article, $wordCount);
            $stmt->execute();

            // Gelen yanıtı temizle
            $generated_article = cleanMarkdown($generated_article);
        } else {
            $error = "API yanıtı beklenmeyen formatta. Lütfen tekrar deneyin.";
        }
    } else {
        $error = "Makale üretilirken bir hata oluştu. Hata kodu: " . $http_code;
        if ($response) {
            $error .= "<br>API Yanıtı: " . htmlspecialchars($response);
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Makale Üretim Sistemi</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-feather-alt"></i>Makale Üretim Sistemi
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">
                            <i class="fas fa-home"></i>Ana Sayfa
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="admin/login.php">
                            <i class="fas fa-user-shield"></i>Admin Girişi
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container mt-5">
        <div class="row">
            <div class="col-lg-5">
                <div class="card animate__animated animate__fadeIn position-sticky" style="top: 90px;">
                    <div class="card-header">
                        <h3><i class="fas fa-robot"></i>Makale Üretim Formu</h3>
                    </div>
                    <div class="card-body">
                        <?php if ($error): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-triangle"></i><?php echo $error; ?>
                            </div>
                        <?php endif; ?>

                        <form method="POST" id="articleForm">
                            <div class="mb-4">
                                <label for="topic" class="form-label">
                                    <i class="fas fa-bookmark"></i>Makale Konusu
                                </label>
                                <input type="text" class="form-control" id="topic" name="topic" 
                                       placeholder="Örn: Yapay Zeka ve Geleceği" required>
                            </div>
                            <div class="mb-4">
                                <label for="keywords" class="form-label">
                                    <i class="fas fa-tags"></i>Anahtar Kelimeler
                                </label>
                                <input type="text" class="form-control" id="keywords" name="keywords" 
                                       placeholder="Örn: yapay zeka, teknoloji, gelecek, inovasyon" required>
                                <div class="form-text">
                                    <i class="fas fa-info-circle"></i>Anahtar kelimeleri virgülle ayırın
                                </div>
                            </div>
                            <div class="mb-4">
                                <label for="wordCount" class="form-label">
                                    <i class="fas fa-text-height"></i>Kelime Sayısı
                                </label>
                                <select class="form-select" id="wordCount" name="wordCount">
                                    <option value="500">500 Kelime</option>
                                    <option value="1000">1000 Kelime</option>
                                    <option value="1500">1500 Kelime</option>
                                    <option value="2000">2000 Kelime</option>
                                </select>
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-brain"></i>Makale Üret
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-7">
                <div class="preview-area animate__animated animate__fadeIn">
                    <?php if ($generated_article): ?>
                        <div class="card">
                            <div class="card-header">
                                <h3><i class="fas fa-file-alt"></i>Üretilen Makale</h3>
                            </div>
                            <div class="card-body">
                                <div class="article-content">
                                    <?php echo nl2br(htmlspecialchars($generated_article)); ?>
                                </div>
                                <div class="mt-4">
                                    <h5><i class="fas fa-tags"></i>Anahtar Kelimeler:</h5>
                                    <div class="keywords">
                                        <?php
                                        $keywords_array = explode(',', $keywords);
                                        foreach ($keywords_array as $keyword) {
                                            echo '<span class="badge"><i class="fas fa-tag"></i>' . 
                                                 trim(htmlspecialchars($keyword)) . '</span>';
                                        }
                                        ?>
                                    </div>
                                </div>
                                <div class="text-center mt-4">
                                    <button type="button" class="btn btn-success" onclick="window.location.reload()">
                                        <i class="fas fa-sync-alt"></i>Yeni Makale Üret
                                    </button>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="card preview-placeholder">
                            <div class="card-header">
                                <h3><i class="fas fa-eye"></i>Makale Ön İzleme</h3>
                            </div>
                            <div class="card-body text-center py-5">
                                <div class="placeholder-content">
                                    <i class="fas fa-file-alt placeholder-icon"></i>
                                    <h4 class="mt-4">Henüz Bir Makale Üretilmedi</h4>
                                    <p class="text-muted">Makale oluşturmak için formu doldurup "Makale Üret" butonuna tıklayın</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <footer class="footer mt-5 py-3">
        <div class="container text-center">
            <span class="text-muted">
                <i class="fas fa-code"></i>Makale Üretim Sistemi &copy; <?php echo date('Y'); ?>
            </span>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        // Form gönderildiğinde loading efekti
        $('#articleForm').on('submit', function() {
            $(this).find('button[type="submit"]').prop('disabled', true)
                .html('<i class="fas fa-spinner fa-spin"></i>Üretiliyor...');
            
            // Ön izleme alanına yükleniyor göster
            if ($('.preview-placeholder').length) {
                $('.placeholder-content').html(`
                    <i class="fas fa-sync-alt fa-spin placeholder-icon"></i>
                    <h4 class="mt-4">Makale Üretiliyor</h4>
                    <p class="text-muted">Lütfen bekleyin...</p>
                `);
            }
        });

        // Sayfa yüklendiğinde animasyon
        $(document).ready(function() {
            $('.navbar-brand i').addClass('animate__animated animate__tada');
            
            // İkonlar için hover efekti
            $('.btn i, .nav-link i, .form-label i').hover(
                function() {
                    $(this).addClass('animate__animated animate__heartBeat');
                },
                function() {
                    $(this).removeClass('animate__animated animate__heartBeat');
                }
            );
        });
    </script>
</body>
</html> 