<?php
// Her şeyden önce oturumu başlat
session_start();

// Database bağlantısını yükle
require_once '../config/database.php';

// Form gönderildi mi kontrol et
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];
    
    // Basit şifre kontrolü (admin123)
    if ($username === 'admin' && $password === 'admin123') {
        // Oturum bilgilerini ayarla
        $_SESSION['admin_id'] = 1;
        $_SESSION['admin_username'] = $username;
        
        // Yönlendirme
        echo "<script>window.location.href = 'dashboard.php';</script>";
        exit();
    } else {
        $error = "Geçersiz kullanıcı adı veya şifre!";
    }
}

// HTML output buradan başlıyor
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Girişi - Makale Üretim Sistemi</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link href="../assets/css/admin.css" rel="stylesheet">
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <div class="card login-card animate__animated animate__fadeIn">
                    <div class="card-header">
                        <h3><i class="fas fa-user-shield"></i>Admin Girişi</h3>
                    </div>
                    <div class="card-body text-center">
                        <div class="login-logo">
                            <i class="fas fa-feather-alt"></i>
                        </div>
                        
                        <?php if (isset($error)): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-triangle"></i><?php echo $error; ?>
                            </div>
                        <?php endif; ?>
                        
                        <form method="POST">
                            <div class="mb-4">
                                <label for="username" class="form-label">
                                    <i class="fas fa-user"></i>Kullanıcı Adı
                                </label>
                                <input type="text" class="form-control" id="username" name="username" required>
                            </div>
                            <div class="mb-4">
                                <label for="password" class="form-label">
                                    <i class="fas fa-lock"></i>Şifre
                                </label>
                                <input type="password" class="form-control" id="password" name="password" required>
                            </div>
                            <div class="d-grid mt-4">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-sign-in-alt"></i>Giriş Yap
                                </button>
                            </div>
                        </form>
                        <div class="mt-4">
                            <a href="../index.php" class="text-muted">
                                <i class="fas fa-home"></i> Ana Sayfaya Dön
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.login-logo i').addClass('animate__animated animate__tada');
            
            // İkonlar için hover efekti
            $('.btn i, .form-label i').hover(
                function() {
                    $(this).addClass('animate__animated animate__heartBeat');
                },
                function() {
                    $(this).removeClass('animate__animated animate__heartBeat');
                }
            );
        });
    </script>
</body>
</html> 