<?php
// Oturumu başlat
session_start();

// Database bağlantısını yükle
require_once '../config/database.php';

// Oturum kontrolü
if (!isset($_SESSION['admin_id'])) {
    echo "<script>window.location.href = 'login.php';</script>";
    exit();
}

$success_message = null;
$error_message = null;
$password_success = null;
$password_error = null;

// API anahtarını güncelle
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['gemini_api_key'])) {
    $api_key = trim($_POST['gemini_api_key']);
    
    if (!empty($api_key)) {
        $sql = "UPDATE settings SET setting_value = ? WHERE setting_key = 'gemini_api_key'";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $api_key);
        
        if ($stmt->execute()) {
            $success_message = "API anahtarı başarıyla güncellendi.";
        } else {
            $error_message = "API anahtarı güncellenirken bir hata oluştu.";
        }
    } else {
        $error_message = "API anahtarı boş olamaz.";
    }
}

// Şifre değiştirme
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['current_password']) && isset($_POST['new_password']) && isset($_POST['confirm_password'])) {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];
    
    // Mevcut şifre doğrulama (basit kontrol - gerçek projede veritabanından kontrol edilmelidir)
    if ($current_password === 'admin123') {
        if ($new_password === $confirm_password) {
            if (strlen($new_password) >= 6) {
                // Normalde veritabanında şifre güncellenirdi, şu an örnek olduğu için sadece bilgi mesajı gösteriyoruz
                // Gerçek projede: UPDATE admin SET password = ? WHERE id = ?
                $password_success = "Şifreniz başarıyla güncellenmiştir.";
            } else {
                $password_error = "Yeni şifre en az 6 karakter uzunluğunda olmalıdır.";
            }
        } else {
            $password_error = "Yeni şifreler eşleşmiyor.";
        }
    } else {
        $password_error = "Mevcut şifreniz hatalı.";
    }
}

// Mevcut API anahtarını al
$sql = "SELECT setting_value FROM settings WHERE setting_key = 'gemini_api_key'";
$result = $conn->query($sql);
$current_api_key = $result->fetch_assoc()['setting_value'];
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ayarlar - Admin Paneli</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link href="../assets/css/admin.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container">
            <a class="navbar-brand" href="dashboard.php">
                <i class="fas fa-tachometer-alt"></i>Admin Paneli
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" href="dashboard.php">
                            <i class="fas fa-chart-bar"></i>Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="settings.php">
                            <i class="fas fa-cog"></i>Ayarlar
                        </a>
                    </li>
                </ul>
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="../index.php">
                            <i class="fas fa-home"></i>Ana Sayfa
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt"></i>Çıkış Yap
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="row">
            <div class="col-md-6 mb-4">
                <div class="card animate__animated animate__fadeIn">
                    <div class="card-header">
                        <h5><i class="fas fa-key"></i>API Ayarları</h5>
                    </div>
                    <div class="card-body">
                        <?php if ($success_message): ?>
                            <div class="alert alert-success">
                                <i class="fas fa-check-circle"></i><?php echo $success_message; ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($error_message): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-triangle"></i><?php echo $error_message; ?>
                            </div>
                        <?php endif; ?>

                        <form method="POST">
                            <div class="mb-4">
                                <label for="gemini_api_key" class="form-label">
                                    <i class="fas fa-key"></i>Gemini API Anahtarı
                                </label>
                                <input type="text" class="form-control" id="gemini_api_key" name="gemini_api_key" 
                                       value="<?php echo htmlspecialchars($current_api_key); ?>" required>
                                <div class="form-text">
                                    <i class="fas fa-info-circle"></i>
                                    Gemini API anahtarınızı buraya girin. API anahtarını 
                                    <a href="https://makersuite.google.com/app/apikey" target="_blank">buradan</a> alabilirsiniz.
                                </div>
                            </div>
                            <div class="text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i>Kaydet
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card animate__animated animate__fadeIn">
                    <div class="card-header">
                        <h5><i class="fas fa-lock"></i>Şifre Değiştir</h5>
                    </div>
                    <div class="card-body">
                        <?php if ($password_success): ?>
                            <div class="alert alert-success">
                                <i class="fas fa-check-circle"></i><?php echo $password_success; ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($password_error): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-triangle"></i><?php echo $password_error; ?>
                            </div>
                        <?php endif; ?>

                        <form method="POST">
                            <div class="mb-4">
                                <label for="current_password" class="form-label">
                                    <i class="fas fa-key"></i>Mevcut Şifre
                                </label>
                                <input type="password" class="form-control" id="current_password" name="current_password" required>
                            </div>
                            <div class="mb-4">
                                <label for="new_password" class="form-label">
                                    <i class="fas fa-lock"></i>Yeni Şifre
                                </label>
                                <input type="password" class="form-control" id="new_password" name="new_password" required>
                                <div class="form-text">
                                    <i class="fas fa-info-circle"></i>
                                    Şifreniz en az 6 karakter uzunluğunda olmalıdır.
                                </div>
                            </div>
                            <div class="mb-4">
                                <label for="confirm_password" class="form-label">
                                    <i class="fas fa-check-circle"></i>Yeni Şifre (Tekrar)
                                </label>
                                <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                            </div>
                            <div class="text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-key"></i>Şifreyi Değiştir
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // İkonlar için hover efekti
            $('.btn i, .nav-link i, .form-label i, .card-header h5 i').hover(
                function() {
                    $(this).addClass('animate__animated animate__heartBeat');
                },
                function() {
                    $(this).removeClass('animate__animated animate__heartBeat');
                }
            );
            
            // Şifre gösterme/gizleme
            $('.toggle-password').click(function() {
                var input = $($(this).attr('toggle'));
                if (input.attr('type') == 'password') {
                    input.attr('type', 'text');
                    $(this).removeClass('fa-eye').addClass('fa-eye-slash');
                } else {
                    input.attr('type', 'password');
                    $(this).removeClass('fa-eye-slash').addClass('fa-eye');
                }
            });
        });
    </script>
</body>
</html> 