<?php
session_start();
include '../config.php';

// Oturum kontrolü
if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
    header("Location: index.php");
    exit;
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Form verilerini al
    $skill_name = $_POST['skill_name'];
    
    // Boş değer kontrolü
    if (empty($skill_name)) {
        header("Location: dashboard.php?error=empty-skill");
        exit;
    }
    
    // Veritabanına ekle
    $sql = "INSERT INTO skills (skill_name) VALUES (?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $skill_name);
    
    if ($stmt->execute()) {
        // Başarılı ekleme
        header("Location: dashboard.php?success=skill-added");
        exit;
    } else {
        // Ekleme hatası
        header("Location: dashboard.php?error=add-failed");
        exit;
    }
} else {
    // POST isteği değilse ana sayfaya yönlendir
    header("Location: dashboard.php");
    exit;
}
?> 