<?php
session_start();
include '../config.php';

// Oturum kontrolü
if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
    header("Location: index.php");
    exit;
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Form verilerini al
    $platform = $_POST['platform'];
    $url = $_POST['url'];
    $icon_class = $_POST['icon_class'];
    
    // URL'nin düzgün biçimde olduğunu kontrol et
    if (!filter_var($url, FILTER_VALIDATE_URL)) {
        header("Location: dashboard.php?error=invalid-url");
        exit;
    }
    
    // Veritabanına ekle
    $sql = "INSERT INTO social_links (platform, url, icon_class) VALUES (?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sss", $platform, $url, $icon_class);
    
    if ($stmt->execute()) {
        // Başarılı ekleme
        header("Location: dashboard.php?success=social-added");
        exit;
    } else {
        // Ekleme hatası
        header("Location: dashboard.php?error=add-failed");
        exit;
    }
} else {
    // POST isteği değilse ana sayfaya yönlendir
    header("Location: dashboard.php");
    exit;
}
?> 