<?php
session_start();
include '../config.php';

// Oturum kontrolü
if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
    header("Location: index.php");
    exit;
}

// Ana içeriği çek
$sql = "SELECT * FROM portfolio_content WHERE id = 1";
$result = $conn->query($sql);
$content = $result->fetch_assoc();

// Sosyal medyaları çek
$socialSql = "SELECT * FROM social_links";
$socialResult = $conn->query($socialSql);

// Becerileri çek
$skillsSql = "SELECT * FROM skills";
$skillsResult = $conn->query($skillsSql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Paneli</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }
        
        body {
            background-color: #f8f9fa;
        }
        
        .container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 250px;
            background-color: #333;
            color: white;
            padding: 20px 0;
            position: fixed;
            height: 100vh;
        }
        
        .sidebar-header {
            padding: 0 20px 20px;
            border-bottom: 1px solid #444;
            text-align: center;
        }
        
        .sidebar-header h3 {
            margin-bottom: 5px;
        }
        
        .sidebar-menu {
            padding: 20px;
        }
        
        .sidebar-menu ul {
            list-style: none;
        }
        
        .sidebar-menu ul li {
            margin-bottom: 15px;
        }
        
        .sidebar-menu ul li a {
            color: #ddd;
            text-decoration: none;
            display: flex;
            align-items: center;
            padding: 8px 15px;
            border-radius: 5px;
            transition: 0.3s;
        }
        
        .sidebar-menu ul li a:hover, .sidebar-menu ul li a.active {
            background-color: #d30303;
            color: white;
        }
        
        .sidebar-menu i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }
        
        .main-content {
            flex: 1;
            margin-left: 250px;
            padding: 20px;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            background-color: white;
            padding: 15px 20px;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
        }
        
        .page-title h1 {
            color: #333;
            font-size: 24px;
        }
        
        .user-info {
            display: flex;
            align-items: center;
        }
        
        .user-info a {
            margin-left: 15px;
            color: #d30303;
            text-decoration: none;
        }
        
        .panel-section {
            background-color: white;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .panel-section h2 {
            margin-bottom: 20px;
            color: #333;
            border-bottom: 1px solid #eee;
            padding-bottom: 10px;
        }
        
        .form-row {
            margin-bottom: 15px;
        }
        
        .form-row label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #444;
        }
        
        .form-row input, .form-row textarea {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }
        
        .form-row textarea {
            height: 120px;
            resize: vertical;
        }
        
        .btn-save {
            background-color: #d30303;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
        }
        
        .btn-save:hover {
            background-color: #b00000;
        }
        
        .tabs {
            display: flex;
            margin-bottom: 20px;
        }
        
        .tab-button {
            padding: 10px 20px;
            background-color: #f1f1f1;
            border: none;
            cursor: pointer;
            margin-right: 5px;
            border-radius: 5px 5px 0 0;
        }
        
        .tab-button.active {
            background-color: #d30303;
            color: white;
        }
        
        .tab-content {
            display: none;
        }
        
        .tab-content.active {
            display: block;
        }
        
        .social-form {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }
        
        .social-form input {
            flex: 1;
            margin-right: 10px;
        }
        
        .btn-add, .btn-remove {
            padding: 8px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
        }
        
        .btn-add {
            background-color: #28a745;
            color: white;
        }
        
        .btn-remove {
            background-color: #dc3545;
            color: white;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        table th, table td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        
        table th {
            background-color: #f8f9fa;
        }
        
        .action-buttons a, .action-buttons button {
            margin-right: 5px;
            padding: 5px 10px;
            border: none;
            border-radius: 3px;
            cursor: pointer;
            color: white;
            text-decoration: none;
            font-size: 14px;
        }
        
        .action-buttons .edit {
            background-color: #007bff;
        }
        
        .action-buttons .delete {
            background-color: #dc3545;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Sidebar -->
        <div class="sidebar">
            <div class="sidebar-header">
                <h3>Admin Paneli</h3>
                <p><?php echo $_SESSION['admin_username']; ?></p>
            </div>
            <div class="sidebar-menu">
                <ul>
                    <li>
                        <a href="#" class="active">
                            <i class="fas fa-home"></i>
                            Ana Sayfa
                        </a>
                    </li>
                    <li>
                        <a href="#" onclick="showTab('profile')">
                            <i class="fas fa-user"></i>
                            Profil Bilgileri
                        </a>
                    </li>
                    <li>
                        <a href="#" onclick="showTab('social')">
                            <i class="fas fa-share-alt"></i>
                            Sosyal Medya
                        </a>
                    </li>
                    <li>
                        <a href="#" onclick="showTab('skills')">
                            <i class="fas fa-code"></i>
                            Beceriler
                        </a>
                    </li>
                    <li>
                        <a href="logout.php">
                            <i class="fas fa-sign-out-alt"></i>
                            Çıkış Yap
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="main-content">
            <div class="header">
                <div class="page-title">
                    <h1>Admin Paneli</h1>
                </div>
                <div class="user-info">
                    <span><?php echo $_SESSION['admin_username']; ?></span>
                    <a href="logout.php">Çıkış Yap</a>
                </div>
            </div>
            
            <div class="tabs">
                <button class="tab-button active" onclick="showTab('profile')">Profil Bilgileri</button>
                <button class="tab-button" onclick="showTab('social')">Sosyal Medya</button>
                <button class="tab-button" onclick="showTab('skills')">Beceriler</button>
            </div>
            
            <!-- Profile Tab -->
            <div id="profile" class="tab-content active">
                <div class="panel-section">
                    <h2>Profil Bilgileri</h2>
                    <form action="update_profile.php" method="post" enctype="multipart/form-data">
                        <div class="form-row">
                            <label for="site_title">Site Başlığı</label>
                            <input type="text" id="site_title" name="site_title" value="<?php echo $content['site_title'] ?? ''; ?>">
                        </div>
                        
                        <div class="form-row">
                            <label for="name">İsim</label>
                            <input type="text" id="name" name="name" value="<?php echo $content['name'] ?? ''; ?>">
                        </div>
                        
                        <div class="form-row">
                            <label for="surname">Soyisim</label>
                            <input type="text" id="surname" name="surname" value="<?php echo $content['surname'] ?? ''; ?>">
                        </div>
                        
                        <div class="form-row">
                            <label for="description">Açıklama</label>
                            <textarea id="description" name="description"><?php echo $content['description'] ?? ''; ?></textarea>
                        </div>
                        
                        <div class="form-row">
                            <label for="button_text">Buton Metni</label>
                            <input type="text" id="button_text" name="button_text" value="<?php echo $content['button_text'] ?? ''; ?>">
                        </div>
                        
                        <div class="form-row">
                            <label for="profile_image">Profil Resmi</label>
                            <?php if(!empty($content['image_path'])): ?>
                                <img src="../<?php echo $content['image_path']; ?>" alt="Mevcut Resim" style="width: 100px; height: auto; margin: 10px 0;">
                            <?php endif; ?>
                            <input type="file" id="profile_image" name="profile_image">
                        </div>
                        
                        <button type="submit" class="btn-save">Kaydet</button>
                    </form>
                </div>
            </div>
            
            <!-- Social Media Tab -->
            <div id="social" class="tab-content">
                <div class="panel-section">
                    <h2>Sosyal Medya Bağlantıları</h2>
                    
                    <table>
                        <thead>
                            <tr>
                                <th>Platform</th>
                                <th>URL</th>
                                <th>İkon Sınıfı</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($social = $socialResult->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $social['platform']; ?></td>
                                <td><?php echo $social['url']; ?></td>
                                <td><?php echo $social['icon_class']; ?></td>
                                <td class="action-buttons">
                                    <a href="edit_social.php?id=<?php echo $social['id']; ?>" class="edit">Düzenle</a>
                                    <a href="delete_social.php?id=<?php echo $social['id']; ?>" class="delete" onclick="return confirm('Bu sosyal medya bağlantısını silmek istediğinize emin misiniz?')">Sil</a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                    
                    <div style="margin-top: 20px;">
                        <h3>Yeni Sosyal Medya Ekle</h3>
                        <form action="add_social.php" method="post">
                            <div class="form-row">
                                <label for="platform">Platform</label>
                                <input type="text" id="platform" name="platform" placeholder="Örn: LinkedIn">
                            </div>
                            
                            <div class="form-row">
                                <label for="url">URL</label>
                                <input type="text" id="url" name="url" placeholder="https://...">
                            </div>
                            
                            <div class="form-row">
                                <label for="icon_class">İkon Sınıfı</label>
                                <input type="text" id="icon_class" name="icon_class" placeholder="Örn: fa-brands fa-linkedin">
                            </div>
                            
                            <button type="submit" class="btn-save">Ekle</button>
                        </form>
                    </div>
                </div>
            </div>
            
            <!-- Skills Tab -->
            <div id="skills" class="tab-content">
                <div class="panel-section">
                    <h2>Becerilerim</h2>
                    
                    <table>
                        <thead>
                            <tr>
                                <th>Beceri Adı</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($skill = $skillsResult->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $skill['skill_name']; ?></td>
                                <td class="action-buttons">
                                    <a href="edit_skill.php?id=<?php echo $skill['id']; ?>" class="edit">Düzenle</a>
                                    <a href="delete_skill.php?id=<?php echo $skill['id']; ?>" class="delete" onclick="return confirm('Bu beceriyi silmek istediğinize emin misiniz?')">Sil</a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                    
                    <div style="margin-top: 20px;">
                        <h3>Yeni Beceri Ekle</h3>
                        <form action="add_skill.php" method="post">
                            <div class="form-row">
                                <label for="skill_name">Beceri Adı</label>
                                <input type="text" id="skill_name" name="skill_name" placeholder="Örn: DEVELOPER">
                            </div>
                            
                            <button type="submit" class="btn-save">Ekle</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        function showTab(tabId) {
            // Tüm tab içeriklerini gizle
            const tabContents = document.querySelectorAll('.tab-content');
            tabContents.forEach(content => {
                content.classList.remove('active');
            });
            
            // Tüm tab butonlarını pasif yap
            const tabButtons = document.querySelectorAll('.tab-button');
            tabButtons.forEach(button => {
                button.classList.remove('active');
            });
            
            // Seçilen tab'ı göster
            document.getElementById(tabId).classList.add('active');
            
            // Seçilen tab butonunu aktif yap
            document.querySelector(`.tab-button[onclick="showTab('${tabId}')"]`).classList.add('active');
        }
    </script>
</body>
</html> 