<?php
session_start();
include '../config.php';

// Oturum kontrolü
if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
    header("Location: index.php");
    exit;
}

// ID kontrolü
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: dashboard.php?error=invalid-id");
    exit;
}

$id = $_GET['id'];

// Veritabanından beceriyi sil
$sql = "DELETE FROM skills WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    // Başarılı silme işlemi
    header("Location: dashboard.php?success=skill-deleted");
    exit;
} else {
    // Silme hatası
    header("Location: dashboard.php?error=delete-failed");
    exit;
}
?> 