<?php
session_start();
include '../config.php';

// Oturum kontrolü
if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
    header("Location: index.php");
    exit;
}

// ID kontrolü
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: dashboard.php?error=invalid-id");
    exit;
}

$id = $_GET['id'];

// POST isteği ile güncelleme yapılıyorsa
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Form verilerini al
    $skill_name = $_POST['skill_name'];
    
    // Boş değer kontrolü
    if (empty($skill_name)) {
        header("Location: edit_skill.php?id=$id&error=empty-skill");
        exit;
    }
    
    // Veritabanını güncelle
    $sql = "UPDATE skills SET skill_name = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("si", $skill_name, $id);
    
    if ($stmt->execute()) {
        // Başarılı güncelleme
        header("Location: dashboard.php?success=skill-updated");
        exit;
    } else {
        // Güncelleme hatası
        header("Location: edit_skill.php?id=$id&error=update-failed");
        exit;
    }
} else {
    // Veritabanından beceri bilgilerini çek
    $sql = "SELECT * FROM skills WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        header("Location: dashboard.php?error=not-found");
        exit;
    }
    
    $skill = $result->fetch_assoc();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Beceri Düzenle</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }
        
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: white;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            padding: 20px;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            border-bottom: 1px solid #eee;
            padding-bottom: 15px;
        }
        
        .header h1 {
            color: #333;
            font-size: 24px;
        }
        
        .form-row {
            margin-bottom: 15px;
        }
        
        .form-row label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #444;
        }
        
        .form-row input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }
        
        .btn-container {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }
        
        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
        }
        
        .btn-save {
            background-color: #d30303;
            color: white;
        }
        
        .btn-save:hover {
            background-color: #b00000;
        }
        
        .btn-cancel {
            background-color: #6c757d;
            color: white;
            text-decoration: none;
            display: inline-block;
            text-align: center;
        }
        
        .btn-cancel:hover {
            background-color: #5a6268;
        }
        
        .error-message {
            color: #d30303;
            margin-bottom: 15px;
            padding: 10px;
            background-color: #f8d7da;
            border-radius: 4px;
            border: 1px solid #f5c6cb;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Beceri Düzenle</h1>
        </div>
        
        <?php if(isset($_GET['error'])): ?>
        <div class="error-message">
            <?php 
            switch($_GET['error']) {
                case 'empty-skill':
                    echo 'Beceri adı boş olamaz.';
                    break;
                case 'update-failed':
                    echo 'Güncelleme sırasında bir hata oluştu.';
                    break;
                default:
                    echo 'Bir hata oluştu.';
            }
            ?>
        </div>
        <?php endif; ?>
        
        <form method="post" action="">
            <div class="form-row">
                <label for="skill_name">Beceri Adı</label>
                <input type="text" id="skill_name" name="skill_name" value="<?php echo htmlspecialchars($skill['skill_name']); ?>" required>
            </div>
            
            <div class="btn-container">
                <button type="submit" class="btn btn-save">Güncelle</button>
                <a href="dashboard.php" class="btn btn-cancel">İptal</a>
            </div>
        </form>
    </div>
</body>
</html> 