<?php
session_start();
include '../config.php';

// Oturum kontrolü
if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
    header("Location: index.php");
    exit;
}

// ID kontrolü
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: dashboard.php?error=invalid-id");
    exit;
}

$id = $_GET['id'];

// POST isteği ile güncelleme yapılıyorsa
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Form verilerini al
    $platform = $_POST['platform'];
    $url = $_POST['url'];
    $icon_class = $_POST['icon_class'];
    
    // URL'nin düzgün biçimde olduğunu kontrol et
    if (!filter_var($url, FILTER_VALIDATE_URL)) {
        header("Location: edit_social.php?id=$id&error=invalid-url");
        exit;
    }
    
    // Veritabanını güncelle
    $sql = "UPDATE social_links SET platform = ?, url = ?, icon_class = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssi", $platform, $url, $icon_class, $id);
    
    if ($stmt->execute()) {
        // Başarılı güncelleme
        header("Location: dashboard.php?success=social-updated");
        exit;
    } else {
        // Güncelleme hatası
        header("Location: edit_social.php?id=$id&error=update-failed");
        exit;
    }
} else {
    // Veritabanından sosyal medya bilgilerini çek
    $sql = "SELECT * FROM social_links WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        header("Location: dashboard.php?error=not-found");
        exit;
    }
    
    $social = $result->fetch_assoc();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sosyal Medya Düzenle</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }
        
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: white;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            padding: 20px;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            border-bottom: 1px solid #eee;
            padding-bottom: 15px;
        }
        
        .header h1 {
            color: #333;
            font-size: 24px;
        }
        
        .form-row {
            margin-bottom: 15px;
        }
        
        .form-row label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #444;
        }
        
        .form-row input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }
        
        .btn-container {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }
        
        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
        }
        
        .btn-save {
            background-color: #d30303;
            color: white;
        }
        
        .btn-save:hover {
            background-color: #b00000;
        }
        
        .btn-cancel {
            background-color: #6c757d;
            color: white;
            text-decoration: none;
            display: inline-block;
            text-align: center;
        }
        
        .btn-cancel:hover {
            background-color: #5a6268;
        }
        
        .error-message {
            color: #d30303;
            margin-bottom: 15px;
            padding: 10px;
            background-color: #f8d7da;
            border-radius: 4px;
            border: 1px solid #f5c6cb;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Sosyal Medya Düzenle</h1>
        </div>
        
        <?php if(isset($_GET['error'])): ?>
        <div class="error-message">
            <?php 
            switch($_GET['error']) {
                case 'invalid-url':
                    echo 'Geçersiz URL formatı. Lütfen geçerli bir URL girin.';
                    break;
                case 'update-failed':
                    echo 'Güncelleme sırasında bir hata oluştu.';
                    break;
                default:
                    echo 'Bir hata oluştu.';
            }
            ?>
        </div>
        <?php endif; ?>
        
        <form method="post" action="">
            <div class="form-row">
                <label for="platform">Platform</label>
                <input type="text" id="platform" name="platform" value="<?php echo htmlspecialchars($social['platform']); ?>" required>
            </div>
            
            <div class="form-row">
                <label for="url">URL</label>
                <input type="text" id="url" name="url" value="<?php echo htmlspecialchars($social['url']); ?>" required>
            </div>
            
            <div class="form-row">
                <label for="icon_class">İkon Sınıfı</label>
                <input type="text" id="icon_class" name="icon_class" value="<?php echo htmlspecialchars($social['icon_class']); ?>" required>
            </div>
            
            <div class="btn-container">
                <button type="submit" class="btn btn-save">Güncelle</button>
                <a href="dashboard.php" class="btn btn-cancel">İptal</a>
            </div>
        </form>
    </div>
</body>
</html> 