<?php
session_start();
include '../config.php';

// Oturum kontrolü
if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
    header("Location: index.php");
    exit;
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Form verilerini al
    $site_title = $_POST['site_title'];
    $name = $_POST['name'];
    $surname = $_POST['surname'];
    $description = $_POST['description'];
    $button_text = $_POST['button_text'];
    
    // Mevcut resim yolunu al
    $image_path_sql = "SELECT image_path FROM portfolio_content WHERE id = 1";
    $image_result = $conn->query($image_path_sql);
    $image_data = $image_result->fetch_assoc();
    $current_image_path = $image_data['image_path'] ?? 'main.jpg';
    
    // Resim yüklemesi varsa
    if (isset($_FILES['profile_image']) && $_FILES['profile_image']['error'] === UPLOAD_ERR_OK) {
        $target_dir = "../uploads/";
        
        // Uploads klasörü yoksa oluştur
        if (!file_exists($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        
        // Benzersiz bir dosya adı oluştur
        $file_extension = pathinfo($_FILES['profile_image']['name'], PATHINFO_EXTENSION);
        $new_filename = 'profile_' . time() . '.' . $file_extension;
        $target_file = $target_dir . $new_filename;
        
        // Resmi yükle
        if (move_uploaded_file($_FILES['profile_image']['tmp_name'], $target_file)) {
            $image_path = "uploads/" . $new_filename;
            
            // Eski resmi sil (varsayılan resim değilse)
            if ($current_image_path != 'main.jpg' && file_exists("../" . $current_image_path)) {
                unlink("../" . $current_image_path);
            }
        } else {
            // Yükleme başarısız olursa mevcut resim yolunu kullan
            $image_path = $current_image_path;
        }
    } else {
        // Yeni resim yüklenmemişse mevcut resim yolunu kullan
        $image_path = $current_image_path;
    }
    
    // Veritabanını güncelle
    $check_sql = "SELECT COUNT(*) as count FROM portfolio_content";
    $check_result = $conn->query($check_sql);
    $check_data = $check_result->fetch_assoc();
    
    if ($check_data['count'] > 0) {
        // Mevcut kaydı güncelle
        $sql = "UPDATE portfolio_content SET 
                site_title = ?, 
                name = ?, 
                surname = ?,
                description = ?,
                button_text = ?,
                image_path = ?
                WHERE id = 1";
                
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssss", $site_title, $name, $surname, $description, $button_text, $image_path);
    } else {
        // Yeni kayıt ekle
        $sql = "INSERT INTO portfolio_content (id, site_title, name, surname, description, button_text, image_path) 
                VALUES (1, ?, ?, ?, ?, ?, ?)";
                
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssss", $site_title, $name, $surname, $description, $button_text, $image_path);
    }
    
    if ($stmt->execute()) {
        // Başarılı güncelleme
        header("Location: dashboard.php?success=profile-updated");
        exit;
    } else {
        // Güncelleme hatası
        header("Location: dashboard.php?error=update-failed");
        exit;
    }
} else {
    // POST isteği değilse ana sayfaya yönlendir
    header("Location: dashboard.php");
    exit;
}
?> 