<?php
session_start();
include 'config.php';

// Veritabanından içeriği çekme
$sql = "SELECT * FROM portfolio_content WHERE id = 1";
$result = $conn->query($sql);
$content = $result->fetch_assoc();

// Sosyal medya bağlantılarını çekme
$socialSql = "SELECT * FROM social_links";
$socialResult = $conn->query($socialSql);
$socialLinks = [];
while ($row = $socialResult->fetch_assoc()) {
    $socialLinks[] = $row;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="https://unpkg.com/aos@next/dist/aos.css" />
    <link rel="stylesheet" href="style.css">
    <title><?php echo $content['site_title'] ?? 'Portfolio Website'; ?></title>
</head>
<body>
    <nav>
        <div class="nav-container">
            <div class="logo" data-aos="zoom-in" data-aos-duration="1500">
                <?php echo $content['name'] ?? 'Charlotte'; ?> <span><?php echo $content['surname'] ?? 'Smith'; ?></span>
            </div>
            <div class="links">
                <div class="link" data-aos="fade-up" data-aos-duration="1500" data-aos-delay="100"><a href="#">Home</a></div>
                <div class="link" data-aos="fade-up" data-aos-duration="1500" data-aos-delay="200"><a href="#">About</a></div>
                <div class="link" data-aos="fade-up" data-aos-duration="1500" data-aos-delay="300"><a href="#">Skills</a></div>
                <div class="link" data-aos="fade-up" data-aos-duration="1500" data-aos-delay="400"><a href="#">Service</a></div>
                <div class="link" data-aos="fade-up" data-aos-duration="1500" data-aos-delay="500"><a href="#">Contact</a></div>
                <?php if(isset($_SESSION['admin']) && $_SESSION['admin'] === true): ?>
                <div class="link" data-aos="fade-up" data-aos-duration="1500" data-aos-delay="600"><a href="admin/dashboard.php">Admin Panel</a></div>
                <?php endif; ?>
            </div>
        </div>
        <i class="fa-solid fa-bars hamburg" onclick="hamburg()"></i>
        <div class="dropdown">
            <div class="links">
                <a href="">Home</a>
                <a href="">About</a>
                <a href="">Skills</a>
                <a href="">Service</a>
                <a href="">Contact</a>
                <?php if(isset($_SESSION['admin']) && $_SESSION['admin'] === true): ?>
                <a href="admin/dashboard.php">Admin Panel</a>
                <?php endif; ?>
                <i class="fa-solid fa-xmark cancel" onclick="cancel()"></i>
            </div>
        </div>
    </nav>
    <section>
        <div class="main-container">
            <div class="content">
                <h1 data-aos="fade-left" data-aos-duration="1500" data-aos-delay="700">Hey I'm <span><?php echo $content['name'] ?? 'Charlotte'; ?></span></h1>
                <div data-aos="fade-right" data-aos-duration="1500" data-aos-delay="900" class="typewriter">I'm a <span class="typewriter-text"></span><label for="">|</label></div>
                <p data-aos="flip-down" data-aos-duration="1500" data-aos-delay="1100"><?php echo $content['description'] ?? 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Incidunt non accusantium nemo amet dolores temporibus.'; ?></p>
                <div class="social-links">
                    <?php 
                    $delay = 1300;
                    foreach ($socialLinks as $link): 
                    ?>
                    <a href="<?php echo $link['url']; ?>" data-aos="fade-up" data-aos-duration="1500" data-aos-delay="<?php echo $delay; ?>"><i class="<?php echo $link['icon_class']; ?>"></i></a>
                    <?php 
                    $delay += 100;
                    endforeach; 
                    ?>
                </div>
                <div class="btn" data-aos="zoom-out" data-aos-duration="1500" data-aos-delay="1800">
                    <button><?php echo $content['button_text'] ?? 'Download CV'; ?></button>
                </div>
            </div>
            <div class="image" data-aos="zoom-in" data-aos-duration="3000">
                <img src="<?php echo $content['image_path'] ?? 'main.jpg'; ?>" alt="">
            </div>
        </div>
    </section>
    <script src="https://unpkg.com/aos@next/dist/aos.js"></script>
    <script>
      AOS.init({offset:0,});
    </script>
    <script>
    // Veritabanından çekilen typewriter metinleri
    const texts = <?php 
        $skillsSql = "SELECT * FROM skills";
        $skillsResult = $conn->query($skillsSql);
        $skills = [];
        while ($row = $skillsResult->fetch_assoc()) {
            $skills[] = $row['skill_name'];
        }
        echo json_encode($skills ?: ["DEVELOPER", "YOUTUBER", "DESIGNER"]);
    ?>;
    </script>
    <script src="script.js"></script>
</body>
</html> 