<?php
// Config dosyasını dahil et
require_once 'config.php';

// Veritabanı zaten mevcut olduğu varsayılıyor, doğrudan config'den gelen bağlantıyı kullanıyoruz
// Bağlantıyı kontrol etme
if ($conn->connect_error) {
    die("Veritabanı bağlantısı başarısız: " . $conn->connect_error);
}

// Türkçe karakter desteği için
$conn->set_charset("utf8");

// portfolio_content tablosunu oluştur
$sql = "CREATE TABLE IF NOT EXISTS portfolio_content (
    id INT(11) PRIMARY KEY,
    site_title VARCHAR(100) NOT NULL,
    name VARCHAR(50) NOT NULL,
    surname VARCHAR(50) NOT NULL,
    description TEXT,
    button_text VARCHAR(50),
    image_path VARCHAR(255)
)";

if ($conn->query($sql) === TRUE) {
    echo "portfolio_content tablosu başarıyla oluşturuldu.<br>";
} else {
    echo "Tablo oluşturma hatası: " . $conn->error . "<br>";
}

// social_links tablosunu oluştur
$sql = "CREATE TABLE IF NOT EXISTS social_links (
    id INT(11) PRIMARY KEY AUTO_INCREMENT,
    platform VARCHAR(50) NOT NULL,
    url VARCHAR(255) NOT NULL,
    icon_class VARCHAR(100) NOT NULL
)";

if ($conn->query($sql) === TRUE) {
    echo "social_links tablosu başarıyla oluşturuldu.<br>";
} else {
    echo "Tablo oluşturma hatası: " . $conn->error . "<br>";
}

// skills tablosunu oluştur
$sql = "CREATE TABLE IF NOT EXISTS skills (
    id INT(11) PRIMARY KEY AUTO_INCREMENT,
    skill_name VARCHAR(50) NOT NULL
)";

if ($conn->query($sql) === TRUE) {
    echo "skills tablosu başarıyla oluşturuldu.<br>";
} else {
    echo "Tablo oluşturma hatası: " . $conn->error . "<br>";
}

// admin tablosunu oluştur
$sql = "CREATE TABLE IF NOT EXISTS admin (
    id INT(11) PRIMARY KEY AUTO_INCREMENT,
    username VARCHAR(50) NOT NULL,
    password VARCHAR(255) NOT NULL
)";

if ($conn->query($sql) === TRUE) {
    echo "admin tablosu başarıyla oluşturuldu.<br>";
} else {
    echo "Tablo oluşturma hatası: " . $conn->error . "<br>";
}

// Örnek veri ekle
// Admin kullanıcısı ekle
$check_admin = "SELECT * FROM admin";
$result = $conn->query($check_admin);

if ($result->num_rows == 0) {
    $admin_username = "admin";
    $admin_password = password_hash("admin123", PASSWORD_DEFAULT);
    
    $sql = "INSERT INTO admin (username, password) VALUES ('$admin_username', '$admin_password')";
    
    if ($conn->query($sql) === TRUE) {
        echo "Varsayılan admin kullanıcısı eklendi. (Kullanıcı adı: admin, Şifre: admin123)<br>";
    } else {
        echo "Admin ekleme hatası: " . $conn->error . "<br>";
    }
}

// Portfolio içeriği ekle
$check_content = "SELECT * FROM portfolio_content";
$result = $conn->query($check_content);

if ($result->num_rows == 0) {
    $sql = "INSERT INTO portfolio_content (id, site_title, name, surname, description, button_text, image_path) 
            VALUES (1, 'Portfolio Website', 'Charlotte', 'Smith', 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Incidunt non accusantium nemo amet dolores temporibus.', 'Download CV', 'main.jpg')";
    
    if ($conn->query($sql) === TRUE) {
        echo "Örnek portfolio içeriği eklendi.<br>";
    } else {
        echo "İçerik ekleme hatası: " . $conn->error . "<br>";
    }
}

// Sosyal medya linkleri ekle
$check_social = "SELECT * FROM social_links";
$result = $conn->query($check_social);

if ($result->num_rows == 0) {
    $social_links = array(
        array("LinkedIn", "https://linkedin.com", "fa-brands fa-linkedin"),
        array("GitHub", "https://github.com", "fa-brands fa-github"),
        array("Facebook", "https://facebook.com", "fa-brands fa-facebook"),
        array("Twitter", "https://twitter.com", "fa-brands fa-twitter")
    );
    
    foreach ($social_links as $link) {
        $sql = "INSERT INTO social_links (platform, url, icon_class) VALUES ('$link[0]', '$link[1]', '$link[2]')";
        
        if ($conn->query($sql) === TRUE) {
            echo "Sosyal medya linki eklendi: $link[0]<br>";
        } else {
            echo "Sosyal medya ekleme hatası: " . $conn->error . "<br>";
        }
    }
}

// Beceriler ekle
$check_skills = "SELECT * FROM skills";
$result = $conn->query($check_skills);

if ($result->num_rows == 0) {
    $skills = array("DEVELOPER", "YOUTUBER", "DESIGNER");
    
    foreach ($skills as $skill) {
        $sql = "INSERT INTO skills (skill_name) VALUES ('$skill')";
        
        if ($conn->query($sql) === TRUE) {
            echo "Beceri eklendi: $skill<br>";
        } else {
            echo "Beceri ekleme hatası: " . $conn->error . "<br>";
        }
    }
}

echo "<br>Kurulum tamamlandı! <a href='index.php'>Ana Sayfaya Git</a> | <a href='admin/index.php'>Admin Paneline Git</a>";

$conn->close();
?> 