                </div>
            </div>
        </div>
    </main>
    
    <footer>
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> Şiir ve Alıntılar - Yönetim Paneli</p>
        </div>
    </footer>
    
    <script src="../assets/js/main.js"></script>
    <script>
        // Alıntı önizleme fonksiyonu
        document.addEventListener('DOMContentLoaded', function() {
            const previewBtn = document.getElementById('preview-btn');
            const previewContainer = document.getElementById('preview-container');
            
            if(previewBtn && previewContainer) {
                previewBtn.addEventListener('click', function() {
                    const baslik = document.getElementById('baslik').value.trim();
                    const icerik = document.getElementById('icerik').value.trim();
                    const yazar = document.getElementById('yazar') ? document.getElementById('yazar').value.trim() : '';
                    const kaynak = document.getElementById('kaynak') ? document.getElementById('kaynak').value.trim() : '';
                    
                    if(!baslik || !icerik) {
                        alert('Önizleme için başlık ve içerik alanları doldurulmalıdır.');
                        return;
                    }
                    
                    // İçeriği paragraf haline getir
                    const formatlanmisIcerik = icerik.replace(/\n\n/g, '</p><p>').replace(/\n/g, '<br>');
                    
                    let previewHTML = `
                        <h3 class="preview-title">${baslik}</h3>
                        <div class="preview-content"><p>${formatlanmisIcerik}</p></div>
                    `;
                    
                    if(yazar || kaynak) {
                        previewHTML += '<div class="preview-meta">';
                        
                        if(yazar) {
                            previewHTML += `<div class="preview-author">- ${yazar}</div>`;
                        }
                        
                        if(kaynak) {
                            previewHTML += `<div class="preview-source">${kaynak}</div>`;
                        }
                        
                        previewHTML += '</div>';
                    }
                    
                    previewContainer.innerHTML = `<h3>Önizleme</h3>${previewHTML}`;
                    previewContainer.style.display = 'block';
                    
                    // Önizleme alanına kaydır
                    previewContainer.scrollIntoView({ behavior: 'smooth' });
                });
            }
            
            // Silme işlemlerinde onay iste
            const silBtnler = document.querySelectorAll('.sil-btn');
            silBtnler.forEach(btn => {
                btn.addEventListener('click', function(e) {
                    if (!confirm('Bu öğeyi silmek istediğinizden emin misiniz?')) {
                        e.preventDefault();
                    }
                });
            });
        });
    </script>
</body>
</html> 