<?php
// Temel dosyaları dahil et
require_once '../config.php';
require_once '../includes/functions.php';

// Admin kontrolü
adminKontrol();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yönetim Paneli - Şiir ve Alıntılar</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        /* Admin paneli ek stilleri */
        .admin-sidebar {
            background-color: var(--secondary-color);
            color: white;
            padding: 1.5rem;
            border-radius: var(--border-radius);
            margin-bottom: 1.5rem;
        }
        
        .admin-menu {
            list-style: none;
            padding: 0;
        }
        
        .admin-menu li {
            margin-bottom: 0.5rem;
        }
        
        .admin-menu a {
            color: white;
            display: block;
            padding: 0.5rem;
            border-radius: var(--border-radius);
            transition: background-color 0.3s;
        }
        
        .admin-menu a:hover,
        .admin-menu a.active {
            background-color: rgba(255, 255, 255, 0.1);
            color: white;
        }
        
        .admin-content {
            background-color: white;
            padding: 1.5rem;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
        }
        
        .admin-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
        }
        
        .admin-title {
            margin: 0;
            color: var(--secondary-color);
        }
        
        .cikis-btn {
            background-color: var(--danger-color) !important;
            color: white !important;
            font-weight: bold;
            margin-top: 1.5rem;
            text-align: center;
        }
        
        .cikis-btn:hover {
            background-color: #c0392b !important;
        }
        
        .cikis-link {
            background-color: var(--danger-color);
            padding: 0.5rem 1rem !important;
            border-radius: var(--border-radius);
            font-weight: bold;
        }
        
        .cikis-link:hover {
            background-color: #c0392b !important;
        }
        
        @media (min-width: 768px) {
            .admin-layout {
                display: grid;
                grid-template-columns: 250px 1fr;
                gap: 1.5rem;
            }
            
            .admin-sidebar {
                margin-bottom: 0;
                height: 100%;
            }
        }
    </style>
</head>
<body>
    <header>
        <div class="container">
            <div class="navbar">
                <div class="logo">
                    <h1><a href="../index.php">Şiir ve Alıntılar</a></h1>
                </div>
                <button class="mobile-menu-toggle">
                    <span></span>
                    <span></span>
                    <span></span>
                </button>
                <ul class="nav-menu">
                    <li><a href="../index.php">Site Ana Sayfa</a></li>
                    <li><a href="index.php">Yönetim Paneli</a></li>
                    <li><a href="../cikis.php" class="cikis-link">Çıkış Yap</a></li>
                </ul>
            </div>
        </div>
    </header>
    
    <main>
        <div class="container">
            <?php uyariGoster(); ?>
            
            <div class="admin-layout">
                <!-- Sidebar -->
                <div class="admin-sidebar">
                    <h3>Yönetim Menüsü</h3>
                    <ul class="admin-menu">
                        <li><a href="index.php" <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'class="active"' : ''; ?>>Kontrol Paneli</a></li>
                        <li><a href="yazilar.php" <?php echo basename($_SERVER['PHP_SELF']) == 'yazilar.php' ? 'class="active"' : ''; ?>>Alıntılar</a></li>
                        <li><a href="yazi-ekle.php" <?php echo basename($_SERVER['PHP_SELF']) == 'yazi-ekle.php' ? 'class="active"' : ''; ?>>Alıntı Ekle</a></li>
                        <li><a href="kategoriler.php" <?php echo basename($_SERVER['PHP_SELF']) == 'kategoriler.php' ? 'class="active"' : ''; ?>>Kategoriler</a></li>
                        <li><a href="../cikis.php" class="cikis-btn">Çıkış Yap</a></li>
                    </ul>
                </div>
                
                <!-- İçerik Alanı -->
                <div class="admin-content"> 