<?php
// Hata raporlamayı etkinleştir
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Temel dosyaları dahil et
require_once '../config.php';
require_once '../includes/functions.php';

// Admin kontrolü
adminKontrol();

// İstatistikler için veritabanı sorguları
try {
    // Toplam yazı sayısı
    $toplamYazilar = $db->query("SELECT COUNT(*) FROM yazilar")->fetchColumn();

    // Toplam kategori sayısı
    $toplamKategoriler = $db->query("SELECT COUNT(*) FROM kategoriler")->fetchColumn();

    // Son eklenen yazılar
    $sonYazilar = $db->query("SELECT * FROM yazilar ORDER BY eklenme_tarihi DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "<div class='alert alert-danger'>Veritabanı hatası: " . $e->getMessage() . "</div>";
    $toplamYazilar = 0;
    $toplamKategoriler = 0;
    $sonYazilar = [];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yönetim Paneli - Şiir ve Alıntılar</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        /* Admin paneli ek stilleri */
        .admin-sidebar {
            background-color: var(--secondary-color);
            color: white;
            padding: 1.5rem;
            border-radius: var(--border-radius);
            margin-bottom: 1.5rem;
        }
        
        .admin-menu {
            list-style: none;
            padding: 0;
        }
        
        .admin-menu li {
            margin-bottom: 0.5rem;
        }
        
        .admin-menu a {
            color: white;
            display: block;
            padding: 0.5rem;
            border-radius: var(--border-radius);
            transition: background-color 0.3s;
        }
        
        .admin-menu a:hover,
        .admin-menu a.active {
            background-color: rgba(255, 255, 255, 0.1);
            color: white;
        }
        
        .admin-content {
            background-color: white;
            padding: 1.5rem;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
        }
        
        .admin-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
        }
        
        .admin-title {
            margin: 0;
            color: var(--secondary-color);
        }
        
        .cikis-btn {
            background-color: var(--danger-color) !important;
            color: white !important;
            font-weight: bold;
            margin-top: 1.5rem;
            text-align: center;
        }
        
        .cikis-btn:hover {
            background-color: #c0392b !important;
        }
        
        .cikis-link {
            background-color: var(--danger-color);
            padding: 0.5rem 1rem !important;
            border-radius: var(--border-radius);
            font-weight: bold;
        }
        
        .cikis-link:hover {
            background-color: #c0392b !important;
        }
        
        .stat-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .stat-box {
            background-color: var(--light-color);
            border-radius: var(--border-radius);
            padding: 1.5rem;
            text-align: center;
            box-shadow: var(--box-shadow);
            transition: transform 0.3s;
        }
        
        .stat-box:hover {
            transform: translateY(-5px);
        }
        
        .stat-value {
            font-size: 2.5rem;
            font-weight: bold;
            color: var(--secondary-color);
            margin-bottom: 0.5rem;
        }
        
        .stat-label {
            color: #666;
            font-size: 1rem;
        }
        
        .son-eklenenler {
            margin-top: 2rem;
        }
        
        .durum {
            display: inline-block;
            padding: 0.25rem 0.5rem;
            border-radius: 3px;
            font-size: 0.8rem;
        }
        
        .durum.aktif {
            background-color: var(--success-color);
            color: white;
        }
        
        .durum.pasif {
            background-color: var(--danger-color);
            color: white;
        }
        
        .tumunu-gor {
            margin-top: 1rem;
            text-align: right;
        }
        
        .btn-sm {
            padding: 0.5rem;
            font-size: 0.9rem;
        }
        
        @media (min-width: 768px) {
            .admin-layout {
                display: grid;
                grid-template-columns: 250px 1fr;
                gap: 1.5rem;
            }
            
            .admin-sidebar {
                margin-bottom: 0;
                height: 100%;
            }
        }
    </style>
</head>
<body>
    <header>
        <div class="container">
            <div class="navbar">
                <div class="logo">
                    <h1><a href="../index.php">Şiir ve Alıntılar</a></h1>
                </div>
                <button class="mobile-menu-toggle">
                    <span></span>
                    <span></span>
                    <span></span>
                </button>
                <ul class="nav-menu">
                    <li><a href="../index.php">Site Ana Sayfa</a></li>
                    <li><a href="index.php">Yönetim Paneli</a></li>
                    <li><a href="../cikis.php" class="cikis-link">Çıkış Yap</a></li>
                </ul>
            </div>
        </div>
    </header>
    
    <main>
        <div class="container">
            <?php uyariGoster(); ?>
            
            <div class="admin-layout">
                <!-- Sidebar -->
                <div class="admin-sidebar">
                    <h3>Yönetim Menüsü</h3>
                    <ul class="admin-menu">
                        <li><a href="index.php" <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'class="active"' : ''; ?>>Kontrol Paneli</a></li>
                        <li><a href="yazilar.php" <?php echo basename($_SERVER['PHP_SELF']) == 'yazilar.php' ? 'class="active"' : ''; ?>>Alıntılar</a></li>
                        <li><a href="yazi-ekle.php" <?php echo basename($_SERVER['PHP_SELF']) == 'yazi-ekle.php' ? 'class="active"' : ''; ?>>Alıntı Ekle</a></li>
                        <li><a href="kategoriler.php" <?php echo basename($_SERVER['PHP_SELF']) == 'kategoriler.php' ? 'class="active"' : ''; ?>>Kategoriler</a></li>
                        <li><a href="../cikis.php" class="cikis-btn">Çıkış Yap</a></li>
                    </ul>
                </div>
                
                <!-- İçerik Alanı -->
                <div class="admin-content">
                    <!-- Admin Paneli Ana Sayfa İçeriği -->
                    <div class="admin-header">
                        <h2 class="admin-title">Kontrol Paneli</h2>
                        <a href="yazi-ekle.php" class="btn">Yeni Alıntı Ekle</a>
                    </div>

                    <!-- İstatistikler -->
                    <div class="istatistikler">
                        <div class="stat-grid">
                            <div class="stat-box">
                                <div class="stat-value"><?php echo $toplamYazilar; ?></div>
                                <div class="stat-label">Toplam Alıntı</div>
                            </div>
                            
                            <div class="stat-box">
                                <div class="stat-value"><?php echo $toplamKategoriler; ?></div>
                                <div class="stat-label">Toplam Kategori</div>
                            </div>
                        </div>
                    </div>

                    <!-- Son Eklenen Alıntılar -->
                    <div class="son-eklenenler">
                        <h3>Son Eklenen Alıntılar</h3>
                        
                        <?php if (count($sonYazilar) > 0): ?>
                            <table class="admin-table">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Başlık</th>
                                        <th>Yazar</th>
                                        <th>Eklenme Tarihi</th>
                                        <th>Durum</th>
                                        <th>İşlemler</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($sonYazilar as $yazi): ?>
                                        <tr>
                                            <td><?php echo $yazi['id']; ?></td>
                                            <td><?php echo $yazi['baslik']; ?></td>
                                            <td><?php echo $yazi['yazar'] ?: 'Belirtilmemiş'; ?></td>
                                            <td><?php echo tarihFormat($yazi['eklenme_tarihi']); ?></td>
                                            <td>
                                                <?php if ($yazi['durum'] == 1): ?>
                                                    <span class="durum aktif">Aktif</span>
                                                <?php else: ?>
                                                    <span class="durum pasif">Pasif</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="admin-actions">
                                                <a href="../alinti.php?id=<?php echo $yazi['id']; ?>" class="btn btn-sm" title="Görüntüle" target="_blank">
                                                    👁️
                                                </a>
                                                <a href="yazi-duzenle.php?id=<?php echo $yazi['id']; ?>" class="btn btn-sm" title="Düzenle">
                                                    ✏️
                                                </a>
                                                <a href="yazi-sil.php?id=<?php echo $yazi['id']; ?>" class="btn btn-sm btn-danger sil-btn" title="Sil">
                                                    🗑️
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                            
                            <div class="tumunu-gor">
                                <a href="yazilar.php" class="btn">Tüm Alıntıları Görüntüle</a>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-info">
                                Henüz hiç alıntı eklenmemiş.
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </main>
    
    <footer>
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> Şiir ve Alıntılar - Yönetim Paneli</p>
        </div>
    </footer>
    
    <script src="../assets/js/main.js"></script>
    <script>
        // Admin panel için JavaScript özelleştirmeleri
        document.addEventListener('DOMContentLoaded', function() {
            // Silme işlemlerinde onay iste
            const silBtnler = document.querySelectorAll('.sil-btn');
            silBtnler.forEach(btn => {
                btn.addEventListener('click', function(e) {
                    if (!confirm('Bu öğeyi silmek istediğinizden emin misiniz?')) {
                        e.preventDefault();
                    }
                });
            });
        });
    </script>
</body>
</html> 