<?php
// Header dosyasını dahil et
require_once 'header.php';

// Form işlemleri - Kategori Ekleme
if (isset($_POST['kategori_ekle'])) {
    $kategori_adi = trim($_POST['kategori_adi']);
    $aciklama = trim($_POST['aciklama'] ?? '');
    
    if (empty($kategori_adi)) {
        uyariOlustur('Kategori adı boş bırakılamaz!', 'danger');
    } else {
        // Kategori adının benzersiz olup olmadığını kontrol et
        $kontrol = $db->prepare("SELECT id FROM kategoriler WHERE kategori_adi = ?");
        $kontrol->execute([$kategori_adi]);
        
        if ($kontrol->rowCount() > 0) {
            uyariOlustur('Bu kategori adı zaten kullanılıyor!', 'danger');
        } else {
            // Kategoriyi ekle
            $ekle = $db->prepare("INSERT INTO kategoriler (kategori_adi, aciklama) VALUES (?, ?)");
            
            if ($ekle->execute([$kategori_adi, $aciklama])) {
                uyariOlustur('Kategori başarıyla eklendi!', 'success');
                // Sayfayı yenile
                header('Location: kategoriler.php');
                exit;
            } else {
                uyariOlustur('Kategori eklenirken bir hata oluştu!', 'danger');
            }
        }
    }
}

// Form işlemleri - Kategori Düzenleme
if (isset($_POST['kategori_duzenle'])) {
    $kategori_id = (int)$_POST['kategori_id'];
    $kategori_adi = trim($_POST['kategori_adi']);
    $aciklama = trim($_POST['aciklama'] ?? '');
    
    if (empty($kategori_adi)) {
        uyariOlustur('Kategori adı boş bırakılamaz!', 'danger');
    } else {
        // Kategori adının benzersiz olup olmadığını kontrol et (kendi ID'si hariç)
        $kontrol = $db->prepare("SELECT id FROM kategoriler WHERE kategori_adi = ? AND id != ?");
        $kontrol->execute([$kategori_adi, $kategori_id]);
        
        if ($kontrol->rowCount() > 0) {
            uyariOlustur('Bu kategori adı zaten kullanılıyor!', 'danger');
        } else {
            // Kategoriyi güncelle
            $guncelle = $db->prepare("UPDATE kategoriler SET kategori_adi = ?, aciklama = ? WHERE id = ?");
            
            if ($guncelle->execute([$kategori_adi, $aciklama, $kategori_id])) {
                uyariOlustur('Kategori başarıyla güncellendi!', 'success');
                // Sayfayı yenile
                header('Location: kategoriler.php');
                exit;
            } else {
                uyariOlustur('Kategori güncellenirken bir hata oluştu!', 'danger');
            }
        }
    }
}

// Kategori Silme İşlemi
if (isset($_GET['sil']) && is_numeric($_GET['sil'])) {
    $kategori_id = (int)$_GET['sil'];
    
    // İlişkili yazıları kontrol et
    $kontrol = $db->prepare("SELECT COUNT(*) FROM yazi_kategori WHERE kategori_id = ?");
    $kontrol->execute([$kategori_id]);
    $iliskiliYaziSayisi = $kontrol->fetchColumn();
    
    if ($iliskiliYaziSayisi > 0) {
        uyariOlustur("Bu kategoriyle ilişkilendirilmiş $iliskiliYaziSayisi adet alıntı bulunuyor. Kategoriyi silmeden önce bu ilişkileri kaldırmanız gerekmektedir.", 'warning');
    } else {
        // Kategoriyi sil
        $sil = $db->prepare("DELETE FROM kategoriler WHERE id = ?");
        
        if ($sil->execute([$kategori_id])) {
            uyariOlustur('Kategori başarıyla silindi!', 'success');
            // Sayfayı yenile
            header('Location: kategoriler.php');
            exit;
        } else {
            uyariOlustur('Kategori silinirken bir hata oluştu!', 'danger');
        }
    }
}

// Kategorileri getir
$kategoriler = [];
try {
    // Kategorileri ve her kategoriye ait alıntı sayısını getir
    $stmt = $db->query("
        SELECT k.*, COUNT(yk.yazi_id) as yazi_sayisi 
        FROM kategoriler k
        LEFT JOIN yazi_kategori yk ON k.id = yk.kategori_id
        GROUP BY k.id
        ORDER BY k.kategori_adi
    ");
    $kategoriler = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo '<div class="alert alert-error">Kategoriler getirilirken bir hata oluştu: ' . $e->getMessage() . '</div>';
}

// Düzenlenecek kategori bilgilerini getir
$duzenle = false;
$duzenlenecekKategori = null;

if (isset($_GET['duzenle']) && is_numeric($_GET['duzenle'])) {
    $duzenle = true;
    $kategori_id = (int)$_GET['duzenle'];
    
    $stmt = $db->prepare("SELECT * FROM kategoriler WHERE id = :id");
    $stmt->bindParam(':id', $kategori_id);
    $stmt->execute();
    $duzenlenecekKategori = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$duzenlenecekKategori) {
        uyariOlustur('Düzenlenecek kategori bulunamadı!', 'danger');
        header('Location: kategoriler.php');
        exit;
    }
}
?>

<!-- Admin Paneli - Kategoriler Sayfası -->
<div class="admin-header">
    <h2 class="admin-title">Kategoriler</h2>
</div>

<div class="kategori-container">
    <div class="kategori-liste">
        <h3>Kategori Listesi</h3>
        
        <?php uyariGoster(); ?>
        
        <?php if (count($kategoriler) > 0): ?>
            <table class="admin-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Kategori Adı</th>
                        <th>Açıklama</th>
                        <th>Alıntı Sayısı</th>
                        <th>İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($kategoriler as $kategori): ?>
                        <tr>
                            <td><?php echo $kategori['id']; ?></td>
                            <td><?php echo $kategori['kategori_adi']; ?></td>
                            <td><?php echo $kategori['aciklama'] ?: '-'; ?></td>
                            <td><?php echo $kategori['yazi_sayisi']; ?></td>
                            <td class="admin-actions">
                                <a href="?duzenle=<?php echo $kategori['id']; ?>" class="btn btn-sm" title="Düzenle">
                                    ✏️
                                </a>
                                <a href="?sil=<?php echo $kategori['id']; ?>" class="btn btn-sm btn-danger sil-btn" title="Sil">
                                    🗑️
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="alert alert-info">
                Henüz hiç kategori eklenmemiş.
            </div>
        <?php endif; ?>
    </div>
    
    <div class="kategori-form">
        <?php if ($duzenle): ?>
            <h3>Kategori Düzenle</h3>
            <form action="" method="post" class="validate-form">
                <input type="hidden" name="kategori_id" value="<?php echo $duzenlenecekKategori['id']; ?>">
                
                <div class="form-group">
                    <label for="kategori_adi">Kategori Adı *</label>
                    <input type="text" id="kategori_adi" name="kategori_adi" class="form-control" value="<?php echo $duzenlenecekKategori['kategori_adi']; ?>" required>
                    <div class="form-feedback"></div>
                </div>
                
                <div class="form-group">
                    <label for="aciklama">Açıklama</label>
                    <textarea id="aciklama" name="aciklama" class="form-control" rows="3"><?php echo $duzenlenecekKategori['aciklama']; ?></textarea>
                </div>
                
                <div class="form-group">
                    <button type="submit" name="kategori_duzenle" class="btn btn-block">Kategoriyi Güncelle</button>
                    <a href="kategoriler.php" class="btn btn-block btn-secondary">İptal</a>
                </div>
            </form>
        <?php else: ?>
            <h3>Yeni Kategori Ekle</h3>
            <form action="" method="post" class="validate-form">
                <div class="form-group">
                    <label for="kategori_adi">Kategori Adı *</label>
                    <input type="text" id="kategori_adi" name="kategori_adi" class="form-control" required>
                    <div class="form-feedback"></div>
                </div>
                
                <div class="form-group">
                    <label for="aciklama">Açıklama</label>
                    <textarea id="aciklama" name="aciklama" class="form-control" rows="3"></textarea>
                </div>
                
                <div class="form-group">
                    <button type="submit" name="kategori_ekle" class="btn btn-block">Kategori Ekle</button>
                </div>
            </form>
        <?php endif; ?>
    </div>
</div>

<style>
    .kategori-container {
        display: grid;
        grid-template-columns: 2fr 1fr;
        gap: 1.5rem;
    }
    
    .kategori-liste, .kategori-form {
        background-color: white;
        padding: 1.5rem;
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow);
    }
    
    .kategori-form h3 {
        margin-top: 0;
        margin-bottom: 1.5rem;
        color: var(--secondary-color);
    }
    
    .btn-secondary {
        background-color: #6c757d;
    }
    
    @media (max-width: 768px) {
        .kategori-container {
            grid-template-columns: 1fr;
        }
        
        .kategori-form {
            order: -1;
        }
    }
</style>

<script>
// Form doğrulama işlemi
document.addEventListener('DOMContentLoaded', function() {
    const forms = document.querySelectorAll('.validate-form');
    
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            let isValid = true;
            
            // Gerekli alanları kontrol et
            const requiredInputs = form.querySelectorAll('[required]');
            requiredInputs.forEach(input => {
                const feedback = input.nextElementSibling;
                if(input.value.trim() === '') {
                    input.classList.add('is-invalid');
                    if(feedback && feedback.classList.contains('form-feedback')) {
                        feedback.textContent = 'Bu alan zorunludur.';
                    }
                    isValid = false;
                } else {
                    input.classList.remove('is-invalid');
                    if(feedback && feedback.classList.contains('form-feedback')) {
                        feedback.textContent = '';
                    }
                }
            });
            
            if(!isValid) {
                e.preventDefault();
                // İlk hatalı alana odaklan
                form.querySelector('.is-invalid').focus();
            }
        });
    });
    
    // Silme işlemi için onay
    const silBtns = document.querySelectorAll('.sil-btn');
    silBtns.forEach(btn => {
        btn.addEventListener('click', function(e) {
            if(!confirm('Bu kategoriyi silmek istediğinizden emin misiniz?')) {
                e.preventDefault();
            }
        });
    });
});
</script>

<?php
// Footer dosyasını dahil et
require_once 'footer.php';
?> 