<?php
// Header dosyasını dahil et
require_once 'header.php';

// ID parametresi kontrolü
if (!isset($_GET['id']) || empty($_GET['id'])) {
    uyariOlustur('Geçersiz alıntı ID\'si!', 'danger');
    header('Location: yazilar.php');
    exit;
}

$id = (int)$_GET['id'];

// Alıntı bilgilerini getir
try {
    $stmt = $db->prepare("SELECT * FROM yazilar WHERE id = :id");
    $stmt->bindParam(':id', $id);
    $stmt->execute();
    $yazi = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$yazi) {
        uyariOlustur('Alıntı bulunamadı!', 'danger');
        header('Location: yazilar.php');
        exit;
    }
    
    // Alıntıya ait kategorileri getir
    $stmt = $db->prepare("SELECT kategori_id FROM yazi_kategori WHERE yazi_id = :yazi_id");
    $stmt->bindParam(':yazi_id', $id);
    $stmt->execute();
    $yaziKategorileri = $stmt->fetchAll(PDO::FETCH_COLUMN);
} catch (PDOException $e) {
    uyariOlustur('Alıntı bilgileri getirilirken bir hata oluştu: ' . $e->getMessage(), 'danger');
    header('Location: yazilar.php');
    exit;
}

// Form işleme
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $baslik = temizle($_POST['baslik'] ?? '');
    $icerik = temizle($_POST['icerik'] ?? '');
    $yazar = temizle($_POST['yazar'] ?? '');
    $kaynak = temizle($_POST['kaynak'] ?? '');
    $durum = isset($_POST['durum']) ? 1 : 0;
    $kategoriler = $_POST['kategoriler'] ?? [];

    // Zorunlu alanları kontrol et
    if (empty($baslik) || empty($icerik)) {
        echo '<div class="alert alert-danger">Başlık ve içerik alanları zorunludur.</div>';
    } else {
        try {
            // Yazıyı güncelle
            $stmt = $db->prepare("UPDATE yazilar SET baslik = ?, icerik = ?, yazar = ?, kaynak = ?, durum = ?, guncelleme_tarihi = NOW() WHERE id = ?");
            $stmt->execute([$baslik, $icerik, $yazar, $kaynak, $durum, $id]);
            
            // Mevcut kategorileri temizle
            $stmt = $db->prepare("DELETE FROM yazi_kategori WHERE yazi_id = ?");
            $stmt->execute([$id]);
            
            // Yeni kategorileri ekle
            if (!empty($kategoriler)) {
                $values = [];
                $params = [];
                
                foreach ($kategoriler as $kategoriId) {
                    $values[] = "(?, ?)";
                    $params[] = $id;
                    $params[] = $kategoriId;
                }
                
                $sql = "INSERT INTO yazi_kategori (yazi_id, kategori_id) VALUES " . implode(', ', $values);
                $stmt = $db->prepare($sql);
                $stmt->execute($params);
            }
            
            uyariOlustur('Alıntı başarıyla güncellendi!', 'success');
            header('Location: yazilar.php');
            exit;
        } catch (PDOException $e) {
            echo '<div class="alert alert-danger">Alıntı güncellenirken bir hata oluştu: ' . $e->getMessage() . '</div>';
        }
    }
}

// Yazıyı getir
try {
    $stmt = $db->prepare("SELECT * FROM yazilar WHERE id = ?");
    $stmt->execute([$id]);
    $yazi = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$yazi) {
        uyariOlustur('Alıntı bulunamadı!', 'danger');
        header('Location: yazilar.php');
        exit;
    }
    
    // Yazıya ait kategorileri getir
    $stmt = $db->prepare("SELECT kategori_id FROM yazi_kategori WHERE yazi_id = ?");
    $stmt->execute([$id]);
    $yaziKategorileri = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    // Tüm kategorileri getir
    $stmt = $db->query("SELECT * FROM kategoriler ORDER BY kategori_adi");
    $kategoriler = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo '<div class="alert alert-danger">Alıntı bilgileri getirilirken bir hata oluştu: ' . $e->getMessage() . '</div>';
}
?>

<!-- Admin Paneli - Alıntı Düzenleme Sayfası -->
<div class="admin-header">
    <h2 class="admin-title">Alıntı Düzenle</h2>
    <div>
        <a href="../alinti.php?id=<?php echo $id; ?>" class="btn" target="_blank">Görüntüle</a>
        <a href="yazilar.php" class="btn">Alıntılara Dön</a>
    </div>
</div>

<!-- Alıntı Düzenleme Formu -->
<form action="" method="post" class="validate-form">
    <div class="form-group">
        <label for="baslik">Başlık *</label>
        <input type="text" id="baslik" name="baslik" class="form-control" value="<?php echo $yazi['baslik']; ?>" required minlength="3" maxlength="255">
        <div class="form-feedback"></div>
    </div>
    
    <div class="form-group">
        <label for="icerik">İçerik *</label>
        <textarea id="icerik" name="icerik" class="form-control" rows="10" required minlength="10"><?php echo $yazi['icerik']; ?></textarea>
        <div class="form-feedback"></div>
    </div>
    
    <div class="form-group">
        <label for="yazar">Yazar</label>
        <input type="text" id="yazar" name="yazar" class="form-control" value="<?php echo $yazi['yazar']; ?>" maxlength="100">
    </div>
    
    <div class="form-group">
        <label for="kaynak">Kaynak</label>
        <input type="text" id="kaynak" name="kaynak" class="form-control" placeholder="Kitap adı, web sitesi vb." value="<?php echo $yazi['kaynak']; ?>" maxlength="255">
    </div>
    
    <div class="form-group">
        <label>Kategoriler</label>
        <div class="kategori-secenekleri">
            <?php foreach ($kategoriler as $kategori): ?>
                <div class="kategori-secim">
                    <input type="checkbox" id="kategori_<?php echo $kategori['id']; ?>" name="kategoriler[]" value="<?php echo $kategori['id']; ?>" <?php echo in_array($kategori['id'], $yaziKategorileri) ? 'checked' : ''; ?>>
                    <label for="kategori_<?php echo $kategori['id']; ?>"><?php echo $kategori['kategori_adi']; ?></label>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="form-info">
            <a href="kategoriler.php" target="_blank">Kategori eklemek için tıklayın</a>
        </div>
    </div>
    
    <div class="form-group">
        <div class="form-check">
            <input type="checkbox" id="durum" name="durum" value="1" <?php echo $yazi['durum'] == 1 ? 'checked' : ''; ?>>
            <label for="durum">Aktif Olarak Yayınla</label>
        </div>
    </div>
    
    <div class="form-group">
        <button type="button" id="preview-btn" class="btn btn-secondary">Önizle</button>
    </div>
    
    <div id="preview-container" style="display: none;" class="yazi-tek">
        <h3>Önizleme</h3>
        <!-- Önizleme içeriği JavaScript ile doldurulacak -->
    </div>
    
    <div class="form-actions">
        <button type="submit" class="btn btn-block">Alıntıyı Güncelle</button>
        <a href="yazi-sil.php?id=<?php echo $id; ?>" class="btn btn-block btn-danger sil-btn">Alıntıyı Sil</a>
    </div>
</form>

<style>
    .kategori-secenekleri {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        gap: 0.5rem;
        margin-bottom: 0.5rem;
    }
    
    .kategori-secim {
        display: flex;
        align-items: center;
    }
    
    .kategori-secim input[type="checkbox"] {
        margin-right: 0.5rem;
    }
    
    .form-info {
        font-size: 0.9rem;
        color: #666;
        margin-top: 0.5rem;
    }
    
    .btn-secondary {
        background-color: #6c757d;
        margin-right: 0.5rem;
    }
    
    #preview-container {
        margin: 1rem 0;
        padding: 1rem;
        border: 1px solid #ddd;
        border-radius: var(--border-radius);
    }
    
    .form-actions {
        display: flex;
        gap: 1rem;
    }
    
    .form-actions .btn {
        flex: 1;
    }
    
    @media (max-width: 768px) {
        .form-actions {
            flex-direction: column;
        }
    }
    
    .form-feedback {
        color: #dc3545;
        font-size: 0.85rem;
        margin-top: 0.25rem;
    }
    
    .is-invalid {
        border-color: #dc3545 !important;
    }
</style>

<script>
// Form doğrulama işlemi
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('.validate-form');
    
    if(form) {
        form.addEventListener('submit', function(e) {
            let isValid = true;
            
            // Gerekli alanları kontrol et
            const requiredInputs = form.querySelectorAll('[required]');
            requiredInputs.forEach(input => {
                const feedback = input.nextElementSibling;
                if(input.value.trim() === '') {
                    input.classList.add('is-invalid');
                    if(feedback && feedback.classList.contains('form-feedback')) {
                        feedback.textContent = 'Bu alan zorunludur.';
                    }
                    isValid = false;
                } else {
                    input.classList.remove('is-invalid');
                    if(feedback && feedback.classList.contains('form-feedback')) {
                        feedback.textContent = '';
                    }
                    
                    // Minimum uzunluk kontrolü
                    if(input.hasAttribute('minlength')) {
                        const minLength = parseInt(input.getAttribute('minlength'));
                        if(input.value.length < minLength) {
                            input.classList.add('is-invalid');
                            if(feedback && feedback.classList.contains('form-feedback')) {
                                feedback.textContent = `En az ${minLength} karakter olmalıdır.`;
                            }
                            isValid = false;
                        }
                    }
                }
            });
            
            if(!isValid) {
                e.preventDefault();
                // İlk hatalı alana odaklan
                form.querySelector('.is-invalid').focus();
            }
        });
    }
});
</script>

<div class="admin-content">
    <div class="container">
        <h1>Alıntı Düzenle</h1>
        
        <?php uyariGoster(); ?>
        
        <!-- İçerik div'i -->
    </div>
</div>

<?php
// Footer dosyasını dahil et
require_once 'footer.php';
?> 