<?php
// Header dosyasını dahil et
require_once 'header.php';

// Form gönderildi mi kontrolü
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $baslik = temizle($_POST['baslik'] ?? '');
    $icerik = temizle($_POST['icerik'] ?? '');
    $yazar = temizle($_POST['yazar'] ?? '');
    $kaynak = temizle($_POST['kaynak'] ?? '');
    $durum = isset($_POST['durum']) ? 1 : 0;
    $kategoriler = $_POST['kategoriler'] ?? [];
    
    // Zorunlu alanları kontrol et
    if (empty($baslik) || empty($icerik)) {
        echo '<div class="alert alert-danger">Başlık ve içerik alanları zorunludur.</div>';
    } else {
        try {
            // Yazıyı veritabanına ekle
            $stmt = $db->prepare("INSERT INTO yazilar (baslik, icerik, yazar, kaynak, durum, eklenme_tarihi, kullanici_id) VALUES (?, ?, ?, ?, ?, NOW(), ?)");
            $stmt->execute([$baslik, $icerik, $yazar, $kaynak, $durum, $_SESSION['kullanici_id']]);
            
            $yaziId = $db->lastInsertId();
            
            // Kategorileri ekle
            if (!empty($kategoriler)) {
                $values = [];
                $params = [];
                
                foreach ($kategoriler as $kategoriId) {
                    $values[] = "(?, ?)";
                    $params[] = $yaziId;
                    $params[] = $kategoriId;
                }
                
                $sql = "INSERT INTO yazi_kategori (yazi_id, kategori_id) VALUES " . implode(', ', $values);
                $stmt = $db->prepare($sql);
                $stmt->execute($params);
            }
            
            uyariOlustur('Alıntı başarıyla eklendi!', 'success');
            header('Location: yazilar.php');
            exit;
        } catch (PDOException $e) {
            echo '<div class="alert alert-danger">Alıntı eklenirken bir hata oluştu: ' . $e->getMessage() . '</div>';
        }
    }
}

// Kategorileri getir
$kategoriler = [];
try {
    $stmt = $db->query("SELECT * FROM kategoriler ORDER BY kategori_adi");
    $kategoriler = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    uyariOlustur('Kategoriler getirilirken bir hata oluştu: ' . $e->getMessage(), 'danger');
}
?>

<!-- Admin Paneli - Alıntı Ekleme Sayfası -->
<div class="admin-header">
    <h2 class="admin-title">Yeni Alıntı Ekle</h2>
    <a href="yazilar.php" class="btn">Alıntılara Dön</a>
</div>

<!-- Alıntı Ekleme Formu -->
<form action="" method="post" class="validate-form">
    <div class="form-group">
        <label for="baslik">Başlık *</label>
        <input type="text" id="baslik" name="baslik" class="form-control" required minlength="3" maxlength="255">
        <div class="form-feedback"></div>
    </div>
    
    <div class="form-group">
        <label for="icerik">İçerik *</label>
        <textarea id="icerik" name="icerik" class="form-control" rows="10" required minlength="10"></textarea>
        <div class="form-feedback"></div>
    </div>
    
    <div class="form-group">
        <label for="yazar">Yazar</label>
        <input type="text" id="yazar" name="yazar" class="form-control" maxlength="100">
    </div>
    
    <div class="form-group">
        <label for="kaynak">Kaynak</label>
        <input type="text" id="kaynak" name="kaynak" class="form-control" placeholder="Kitap adı, web sitesi vb." maxlength="255">
    </div>
    
    <div class="form-group">
        <label>Kategoriler</label>
        <div class="kategori-secenekleri">
            <?php foreach ($kategoriler as $kategori): ?>
                <div class="kategori-secim">
                    <input type="checkbox" id="kategori_<?php echo $kategori['id']; ?>" name="kategoriler[]" value="<?php echo $kategori['id']; ?>">
                    <label for="kategori_<?php echo $kategori['id']; ?>"><?php echo $kategori['kategori_adi']; ?></label>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="form-info">
            <a href="kategoriler.php" target="_blank">Kategori eklemek için tıklayın</a>
        </div>
    </div>
    
    <div class="form-group">
        <div class="form-check">
            <input type="checkbox" id="durum" name="durum" value="1" checked>
            <label for="durum">Aktif Olarak Yayınla</label>
        </div>
    </div>
    
    <div class="form-group">
        <button type="button" id="preview-btn" class="btn btn-secondary">Önizle</button>
    </div>
    
    <div id="preview-container" style="display: none;" class="yazi-tek">
        <h3>Önizleme</h3>
        <!-- Önizleme içeriği JavaScript ile doldurulacak -->
    </div>
    
    <div class="form-group">
        <button type="submit" class="btn btn-block">Alıntıyı Ekle</button>
    </div>
</form>

<style>
    .kategori-secenekleri {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        gap: 0.5rem;
        margin-bottom: 0.5rem;
    }
    
    .kategori-secim {
        display: flex;
        align-items: center;
    }
    
    .kategori-secim input[type="checkbox"] {
        margin-right: 0.5rem;
    }
    
    .form-info {
        font-size: 0.9rem;
        color: #666;
        margin-top: 0.5rem;
    }
    
    .btn-secondary {
        background-color: #6c757d;
        margin-right: 0.5rem;
    }
    
    #preview-container {
        margin: 1rem 0;
        padding: 1rem;
        border: 1px solid #ddd;
        border-radius: var(--border-radius);
    }
    
    .form-feedback {
        color: #dc3545;
        font-size: 0.85rem;
        margin-top: 0.25rem;
    }
    
    .is-invalid {
        border-color: #dc3545 !important;
    }
</style>

<script>
// Form doğrulama işlemi
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('.validate-form');
    
    if(form) {
        form.addEventListener('submit', function(e) {
            let isValid = true;
            
            // Gerekli alanları kontrol et
            const requiredInputs = form.querySelectorAll('[required]');
            requiredInputs.forEach(input => {
                const feedback = input.nextElementSibling;
                if(input.value.trim() === '') {
                    input.classList.add('is-invalid');
                    if(feedback && feedback.classList.contains('form-feedback')) {
                        feedback.textContent = 'Bu alan zorunludur.';
                    }
                    isValid = false;
                } else {
                    input.classList.remove('is-invalid');
                    if(feedback && feedback.classList.contains('form-feedback')) {
                        feedback.textContent = '';
                    }
                    
                    // Minimum uzunluk kontrolü
                    if(input.hasAttribute('minlength')) {
                        const minLength = parseInt(input.getAttribute('minlength'));
                        if(input.value.length < minLength) {
                            input.classList.add('is-invalid');
                            if(feedback && feedback.classList.contains('form-feedback')) {
                                feedback.textContent = `En az ${minLength} karakter olmalıdır.`;
                            }
                            isValid = false;
                        }
                    }
                }
            });
            
            if(!isValid) {
                e.preventDefault();
                // İlk hatalı alana odaklan
                form.querySelector('.is-invalid').focus();
            }
        });
    }
});
</script>

<div class="admin-content">
    <div class="container">
        <h1>Yeni Alıntı Ekle</h1>
        
        <?php uyariGoster(); ?>
        
        <!-- İçerik div'i -->
    </div>
</div>

<?php
// Footer dosyasını dahil et
require_once 'footer.php';
?> 