<?php
// Header dosyasını dahil et (sadece oturum kontrolü için)
require_once '../config.php';
require_once '../includes/functions.php';

// Admin kontrolü
adminKontrol();

// ID parametresi kontrolü
if (!isset($_GET['id']) || empty($_GET['id'])) {
    uyariOlustur('Geçersiz alıntı ID\'si!', 'danger');
    header('Location: yazilar.php');
    exit;
}

$id = (int)$_GET['id'];

// Yazının var olup olmadığını kontrol et
try {
    $stmt = $db->prepare("SELECT id FROM yazilar WHERE id = :id");
    $stmt->bindParam(':id', $id);
    $stmt->execute();
    
    if ($stmt->rowCount() === 0) {
        uyariOlustur('Silinecek alıntı bulunamadı!', 'danger');
        header('Location: yazilar.php');
        exit;
    }
    
    // Önce yazı-kategori ilişkilerini sil
    $stmt = $db->prepare("DELETE FROM yazi_kategori WHERE yazi_id = :id");
    $stmt->bindParam(':id', $id);
    $stmt->execute();
    
    // Şimdi yazıyı sil
    $stmt = $db->prepare("DELETE FROM yazilar WHERE id = :id");
    $stmt->bindParam(':id', $id);
    
    if ($stmt->execute()) {
        uyariOlustur('Alıntı başarıyla silindi!', 'success');
    } else {
        uyariOlustur('Alıntı silinirken bir hata oluştu!', 'danger');
    }
    
} catch (PDOException $e) {
    uyariOlustur('Alıntı silinirken bir hata oluştu: ' . $e->getMessage(), 'danger');
}

// Yazılar sayfasına yönlendir
header('Location: yazilar.php');
exit; 