<?php
// Header dosyasını dahil et
require_once 'header.php';

// Sayfalama için değişkenler
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$limit = 10; // Her sayfada gösterilecek alıntı sayısı

// Filtreler
$arama = isset($_GET['arama']) ? temizle($_GET['arama']) : '';
$kategori = isset($_GET['kategori']) ? (int)$_GET['kategori'] : 0;
$durum = isset($_GET['durum']) ? (int)$_GET['durum'] : -1; // -1: Tümü, 0: Pasif, 1: Aktif

// SQL sorgusu için koşullar
$where = [];
$params = [];

if (!empty($arama)) {
    $where[] = "(baslik LIKE :arama OR icerik LIKE :arama OR yazar LIKE :arama)";
    $params[':arama'] = "%$arama%";
}

if ($kategori > 0) {
    // Daha verimli bir kategori filtreleme yaklaşımı
    // Alt sorgu (subquery) yerine JOIN kullanımı
    $joinKategori = true;
    $where[] = "yk.kategori_id = :kategori";
    $params[':kategori'] = $kategori;
} else {
    $joinKategori = false;
}

if ($durum != -1) {
    $where[] = "yazilar.durum = :durum";
    $params[':durum'] = $durum;
}

// WHERE koşulunu oluştur
$whereStr = !empty($where) ? "WHERE " . implode(" AND ", $where) : "";

// JOIN koşulunu oluştur
$joinStr = $joinKategori ? "INNER JOIN yazi_kategori yk ON yazilar.id = yk.yazi_id" : "";

// Toplam alıntı sayısını hesapla
$countSql = "SELECT COUNT(DISTINCT yazilar.id) as toplam FROM yazilar $joinStr $whereStr";
$countStmt = $db->prepare($countSql);
foreach ($params as $key => $value) {
    $countStmt->bindValue($key, $value);
}
$countStmt->execute();
$toplamYazi = $countStmt->fetch(PDO::FETCH_ASSOC)['toplam'];
$toplamSayfa = ceil($toplamYazi / $limit);

// Sayfa numarası kontrolü
if ($sayfa < 1) $sayfa = 1;
if ($sayfa > $toplamSayfa && $toplamSayfa > 0) $sayfa = $toplamSayfa;

// Limit ve offset hesapla
$offset = ($sayfa - 1) * $limit;

// Alıntıları getir
$sql = "SELECT DISTINCT yazilar.*, 
        (SELECT GROUP_CONCAT(kategoriler.kategori_adi) 
        FROM yazi_kategori 
        INNER JOIN kategoriler ON yazi_kategori.kategori_id = kategoriler.id 
        WHERE yazi_kategori.yazi_id = yazilar.id) as kategoriler 
        FROM yazilar 
        $joinStr
        $whereStr 
        ORDER BY yazilar.eklenme_tarihi DESC 
        LIMIT :limit OFFSET :offset";

$stmt = $db->prepare($sql);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);

foreach ($params as $key => $value) {
    $stmt->bindValue($key, $value);
}

$stmt->execute();
$yazilar = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Kategorileri getir (filtre için)
$kategoriler = $db->query("SELECT * FROM kategoriler ORDER BY kategori_adi")->fetchAll(PDO::FETCH_ASSOC);
?>

<!-- Admin Paneli - Alıntılar Sayfası -->
<div class="admin-content">
    <div class="container">
        <h1>Alıntılar</h1>
        
        <?php uyariGoster(); ?>
        
        <div class="admin-header">
            <h2 class="admin-title">Alıntılar</h2>
            <a href="yazi-ekle.php" class="btn">Yeni Alıntı Ekle</a>
        </div>

        <!-- Filtreler -->
        <div class="filtreler">
            <form action="" method="get" class="filtre-form">
                <div class="filtre-satir">
                    <div class="filtre-grup">
                        <input type="text" name="arama" value="<?php echo $arama; ?>" placeholder="Arama..." class="form-control">
                    </div>
                    
                    <div class="filtre-grup">
                        <select name="kategori" class="form-control">
                            <option value="0">Tüm Kategoriler</option>
                            <?php foreach ($kategoriler as $kat): ?>
                                <option value="<?php echo $kat['id']; ?>" <?php echo $kategori == $kat['id'] ? 'selected' : ''; ?>>
                                    <?php echo $kat['kategori_adi']; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="filtre-grup">
                        <select name="durum" class="form-control">
                            <option value="-1" <?php echo $durum == -1 ? 'selected' : ''; ?>>Tüm Durumlar</option>
                            <option value="1" <?php echo $durum == 1 ? 'selected' : ''; ?>>Aktif</option>
                            <option value="0" <?php echo $durum === 0 ? 'selected' : ''; ?>>Pasif</option>
                        </select>
                    </div>
                    
                    <div class="filtre-grup">
                        <button type="submit" class="btn">Filtrele</button>
                        <a href="yazilar.php" class="btn btn-secondary">Sıfırla</a>
                    </div>
                </div>
            </form>
        </div>

        <!-- Alıntılar Tablosu -->
        <div class="yazilar-tablosu">
            <?php if (count($yazilar) > 0): ?>
                <table class="admin-table">
                    <thead>
                        <tr>
                            <th style="width: 50px;">ID</th>
                            <th>Başlık</th>
                            <th>Yazar</th>
                            <th>Kategoriler</th>
                            <th style="width: 120px;">Tarih</th>
                            <th style="width: 80px;">Durum</th>
                            <th style="width: 120px;">İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($yazilar as $yazi): ?>
                            <tr>
                                <td><?php echo $yazi['id']; ?></td>
                                <td><?php echo $yazi['baslik']; ?></td>
                                <td><?php echo $yazi['yazar'] ?: 'Belirtilmemiş'; ?></td>
                                <td><?php echo $yazi['kategoriler'] ?: 'Kategorisiz'; ?></td>
                                <td><?php echo tarihFormat($yazi['eklenme_tarihi']); ?></td>
                                <td>
                                    <?php if ($yazi['durum'] == 1): ?>
                                        <span class="durum aktif">Aktif</span>
                                    <?php else: ?>
                                        <span class="durum pasif">Pasif</span>
                                    <?php endif; ?>
                                </td>
                                <td class="admin-actions">
                                    <a href="../alinti.php?id=<?php echo $yazi['id']; ?>" class="btn btn-sm" title="Görüntüle" target="_blank">
                                        👁️
                                    </a>
                                    <a href="yazi-duzenle.php?id=<?php echo $yazi['id']; ?>" class="btn btn-sm" title="Düzenle">
                                        ✏️
                                    </a>
                                    <a href="yazi-sil.php?id=<?php echo $yazi['id']; ?>" class="btn btn-sm btn-danger sil-btn" title="Sil">
                                        🗑️
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                
                <!-- Sayfalama -->
                <?php if ($toplamSayfa > 1): ?>
                    <div class="sayfalama-container">
                        <ul class="pagination">
                            <?php if ($sayfa > 1): ?>
                                <li><a href="?sayfa=<?php echo $sayfa - 1; ?>&arama=<?php echo urlencode($arama); ?>&kategori=<?php echo $kategori; ?>&durum=<?php echo $durum; ?>">&laquo;</a></li>
                            <?php else: ?>
                                <li class="disabled"><a>&laquo;</a></li>
                            <?php endif; ?>
                            
                            <?php for ($i = max(1, $sayfa - 2); $i <= min($toplamSayfa, $sayfa + 2); $i++): ?>
                                <li <?php echo $i == $sayfa ? 'class="active"' : ''; ?>>
                                    <a href="?sayfa=<?php echo $i; ?>&arama=<?php echo urlencode($arama); ?>&kategori=<?php echo $kategori; ?>&durum=<?php echo $durum; ?>">
                                        <?php echo $i; ?>
                                    </a>
                                </li>
                            <?php endfor; ?>
                            
                            <?php if ($sayfa < $toplamSayfa): ?>
                                <li><a href="?sayfa=<?php echo $sayfa + 1; ?>&arama=<?php echo urlencode($arama); ?>&kategori=<?php echo $kategori; ?>&durum=<?php echo $durum; ?>">&raquo;</a></li>
                            <?php else: ?>
                                <li class="disabled"><a>&raquo;</a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                <?php endif; ?>
                
                <div class="toplam-bilgi">
                    Toplam <?php echo $toplamYazi; ?> alıntı bulundu.
                </div>
            <?php else: ?>
                <div class="alert alert-info">
                    Arama kriterlerinize uygun alıntı bulunamadı.
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
    .filtreler {
        margin-bottom: 1.5rem;
    }
    
    .filtre-form {
        background-color: #f8f9fa;
        padding: 1rem;
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow);
    }
    
    .filtre-satir {
        display: flex;
        flex-wrap: wrap;
        gap: 0.5rem;
    }
    
    .filtre-grup {
        flex: 1;
        min-width: 200px;
    }
    
    .btn-secondary {
        background-color: #6c757d;
    }
    
    .durum {
        display: inline-block;
        padding: 0.25rem 0.5rem;
        border-radius: 3px;
        font-size: 0.8rem;
    }
    
    .durum.aktif {
        background-color: var(--success-color);
        color: white;
    }
    
    .durum.pasif {
        background-color: var(--danger-color);
        color: white;
    }
    
    .toplam-bilgi {
        margin-top: 1rem;
        text-align: right;
        font-style: italic;
        color: #666;
    }
    
    @media (max-width: 768px) {
        .filtre-grup {
            min-width: 100%;
        }
    }
</style>

<?php
// Footer dosyasını dahil et
require_once 'footer.php';
?> 