<?php
// Header'ı dahil et
require_once 'includes/header.php';

// ID parametresi kontrolü
if (!isset($_GET['id']) || empty($_GET['id'])) {
    uyariOlustur('Geçersiz alıntı ID\'si!', 'danger');
    header('Location: index.php');
    exit;
}

$id = (int)$_GET['id'];

// Alıntı detayını getir
$alinti = alintiDetay($db, $id);

// Alıntı bulunamadı kontrolü
if (!$alinti) {
    uyariOlustur('Alıntı bulunamadı!', 'danger');
    header('Location: index.php');
    exit;
}

// Alıntı kategorileri
$kategoriler = $alinti['kategoriler'] ? explode(',', $alinti['kategoriler']) : [];
?>

<!-- Alıntı Detayı -->
<div class="yazi-tek">
    <h1 class="yazi-baslik"><?php echo $alinti['baslik']; ?></h1>
    
    <div class="yazi-meta">
        <span class="yazi-yazar">Yazar: <?php echo $alinti['yazar'] ?: 'Anonim'; ?></span>
        <?php if ($alinti['kaynak']): ?>
            | <span class="yazi-kaynak">Kaynak: <?php echo $alinti['kaynak']; ?></span>
        <?php endif; ?>
        | <span class="yazi-tarih">Eklenme: <?php echo tarihFormat($alinti['eklenme_tarihi']); ?></span>
    </div>
    
    <?php if (!empty($kategoriler)): ?>
        <div class="yazi-kategoriler">
            Kategoriler: 
            <?php foreach ($kategoriler as $index => $kategori): ?>
                <a href="kategori.php?id=<?php echo $kategori; ?>"><?php echo $kategori; ?></a><?php echo ($index < count($kategoriler) - 1) ? ', ' : ''; ?>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
    
    <div class="yazi-icerik">
        <?php echo nl2br($alinti['icerik']); ?>
    </div>
    
    <!-- Sosyal Medya Paylaşım -->
    <div class="sosyal-paylasim">
        <p>Bu alıntıyı paylaş:</p>
        <a href="https://twitter.com/intent/tweet?text=<?php echo urlencode($alinti['baslik'] . ' - ' . kisaMetin($alinti['icerik'], 100) . ' | ' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']); ?>" target="_blank" class="btn btn-sm">Twitter</a>
        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode($_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']); ?>" target="_blank" class="btn btn-sm">Facebook</a>
        <a href="https://wa.me/?text=<?php echo urlencode($alinti['baslik'] . ' - ' . kisaMetin($alinti['icerik'], 100) . ' | ' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']); ?>" target="_blank" class="btn btn-sm">WhatsApp</a>
    </div>
</div>

<!-- Benzer Alıntılar -->
<h3>Diğer Alıntılar</h3>
<?php 
// Son eklenen diğer 3 alıntıyı getir
$sonAlintiler = sonAlintilariGetir($db, 3);

if (count($sonAlintiler) > 0):
?>
    <div class="yazilar-container">
        <?php foreach ($sonAlintiler as $yazi): ?>
            <?php if ($yazi['id'] != $id): // Mevcut alıntıyı gösterme ?>
                <div class="yazi-card">
                    <div class="yazi-card-header">
                        <h3><?php echo $yazi['baslik']; ?></h3>
                    </div>
                    <div class="yazi-card-body">
                        <div class="yazi-card-content"><?php echo kisaMetin($yazi['icerik'], 100); ?></div>
                        <a href="alinti.php?id=<?php echo $yazi['id']; ?>" class="btn">Devamını Oku</a>
                    </div>
                    <div class="yazi-card-footer">
                        <div class="yazi-yazar"><?php echo $yazi['yazar'] ?: 'Anonim'; ?></div>
                        <div class="yazi-tarih"><?php echo tarihFormat($yazi['eklenme_tarihi']); ?></div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<div class="geri-don">
    <a href="index.php" class="btn">&laquo; Ana Sayfaya Dön</a>
</div>

<?php
// Footer'ı dahil et
require_once 'includes/footer.php';
?> 