<?php
// Header'ı dahil et
require_once 'includes/header.php';

// Arama sorgusu var mı?
$q = isset($_GET['q']) ? temizle($_GET['q']) : '';
$arananYazilar = [];
$toplamSonuc = 0;

// Arama yapıldı mı?
$aramaTamamlandi = false;

if (!empty($q)) {
    $aramaTamamlandi = true;
    
    try {
        // Arama sorgusu
        $stmt = $db->prepare("
            SELECT y.*, GROUP_CONCAT(k.kategori_adi) as kategoriler 
            FROM yazilar y 
            LEFT JOIN yazi_kategori yk ON y.id = yk.yazi_id 
            LEFT JOIN kategoriler k ON yk.kategori_id = k.id 
            WHERE y.durum = 1 AND (
                y.baslik LIKE :arama 
                OR y.icerik LIKE :arama 
                OR y.yazar LIKE :arama
                OR y.kaynak LIKE :arama
            )
            GROUP BY y.id
            ORDER BY y.eklenme_tarihi DESC
        ");
        
        $aramaParametresi = "%$q%";
        $stmt->bindParam(':arama', $aramaParametresi);
        $stmt->execute();
        
        $arananYazilar = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $toplamSonuc = count($arananYazilar);
    } catch (PDOException $e) {
        uyariOlustur('Arama yapılırken bir hata oluştu: ' . $e->getMessage(), 'danger');
    }
}
?>

<!-- Arama Sayfası -->
<div class="arama-container">
    <h1 class="sayfa-baslik">Alıntı Ara</h1>
    
    <form action="" method="get" class="arama-form">
        <div class="arama-grup">
            <input type="text" name="q" value="<?php echo $q; ?>" placeholder="Alıntılarda ara..." class="form-control" required>
            <button type="submit" class="btn">Ara</button>
        </div>
        <p class="arama-bilgi">Başlık, içerik, yazar veya kaynak bilgisi içinde arama yapabilirsiniz.</p>
    </form>
    
    <?php if ($aramaTamamlandi): ?>
        <div class="arama-sonuclari">
            <h2 class="sonuc-baslik">
                <?php if (!empty($q)): ?>
                    <span>"<?php echo $q; ?>"</span> için arama sonuçları
                <?php endif; ?>
            </h2>
            
            <?php if ($toplamSonuc > 0): ?>
                <p class="sonuc-bilgi">Toplam <?php echo $toplamSonuc; ?> sonuç bulundu.</p>
                
                <div class="yazilar-container">
                    <?php foreach ($arananYazilar as $yazi): ?>
                        <div class="yazi-card">
                            <div class="yazi-card-header">
                                <h3><?php echo $yazi['baslik']; ?></h3>
                            </div>
                            <div class="yazi-card-body">
                                <div class="yazi-card-content"><?php echo kisaMetin($yazi['icerik'], 200); ?></div>
                                <a href="alinti.php?id=<?php echo $yazi['id']; ?>" class="btn">Devamını Oku</a>
                            </div>
                            <div class="yazi-card-footer">
                                <div class="yazi-yazar"><?php echo $yazi['yazar'] ?: 'Anonim'; ?></div>
                                <div class="yazi-tarih"><?php echo tarihFormat($yazi['eklenme_tarihi']); ?></div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="alert alert-info">
                    Arama kriterlerinize uygun sonuç bulunamadı.
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<style>
    .arama-container {
        max-width: 800px;
        margin: 0 auto;
    }
    
    .sayfa-baslik {
        color: var(--secondary-color);
        margin-bottom: 1.5rem;
        text-align: center;
    }
    
    .arama-form {
        margin-bottom: 2rem;
    }
    
    .arama-grup {
        display: flex;
        gap: 0.5rem;
    }
    
    .arama-bilgi {
        color: #666;
        font-size: 0.9rem;
        margin-top: 0.5rem;
    }
    
    .sonuc-baslik {
        color: var(--secondary-color);
        margin-bottom: 1rem;
        font-size: 1.5rem;
    }
    
    .sonuc-baslik span {
        font-style: italic;
    }
    
    .sonuc-bilgi {
        margin-bottom: 1.5rem;
        font-style: italic;
        color: #666;
    }
    
    @media (max-width: 576px) {
        .arama-grup {
            flex-direction: column;
        }
    }
</style>

<?php
// Footer'ı dahil et
require_once 'includes/footer.php';
?> 