<?php
// Session başlat
session_start();

// Hata raporlamayı etkinleştir
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Veritabanı bağlantısını dahil et
require_once 'config.php';
require_once 'includes/functions.php';

// Eğer kullanıcı zaten giriş yapmışsa
if (isset($_SESSION['kullanici_id']) && isset($_SESSION['kullanici_yetki']) && $_SESSION['kullanici_yetki'] == 'admin') {
    // Admin paneline yönlendir
    header('Location: admin/index.php');
    exit;
}

// Form gönderilmişse
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $kullanici_adi = $_POST['kullanici_adi'] ?? '';
    $sifre = $_POST['sifre'] ?? '';
    $hata = '';
    
    if (empty($kullanici_adi) || empty($sifre)) {
        $hata = 'Kullanıcı adı ve şifre gereklidir.';
    } else {
        try {
            // Sadece admin kullanıcı adını kabul et
            if ($kullanici_adi != 'admin') {
                $hata = 'Geçersiz kullanıcı adı veya şifre.';
            } else {
                // Kullanıcıyı veritabanında ara
                $stmt = $db->prepare("SELECT * FROM kullanicilar WHERE kullanici_adi = :kullanici_adi");
                $stmt->execute([':kullanici_adi' => $kullanici_adi]);
                $kullanici = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($kullanici && password_verify($sifre, $kullanici['sifre'])) {
                    // Kullanıcı doğrulandı, oturumu başlat
                    $_SESSION['kullanici_id'] = $kullanici['id'];
                    $_SESSION['kullanici_adi'] = $kullanici['kullanici_adi'];
                    $_SESSION['kullanici_yetki'] = 'admin';
                    
                    // Yönetim paneline yönlendir
                    header('Location: admin/index.php');
                    exit;
                } else {
                    $hata = 'Geçersiz kullanıcı adı veya şifre.';
                }
            }
        } catch (PDOException $e) {
            $hata = 'Giriş sırasında bir hata oluştu: ' . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yönetici Girişi - Şiir ve Alıntılar</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <header>
        <div class="container">
            <div class="navbar">
                <div class="logo">
                    <h1><a href="index.php">Şiir ve Alıntılar</a></h1>
                </div>
                <button class="mobile-menu-toggle">
                    <span></span>
                    <span></span>
                    <span></span>
                </button>
                <ul class="nav-menu">
                    <li><a href="index.php">Ana Sayfa</a></li>
                    <li><a href="kategoriler.php">Kategoriler</a></li>
                </ul>
            </div>
        </div>
    </header>
    
    <main>
        <div class="container">
            <div class="auth-form">
                <h2>Yönetici Girişi</h2>
                
                <?php if (isset($hata) && !empty($hata)): ?>
                    <div class="alert alert-danger">
                        <?php echo $hata; ?>
                    </div>
                <?php endif; ?>
                
                <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
                    <div class="form-group">
                        <label for="kullanici_adi">Kullanıcı Adı</label>
                        <input type="text" id="kullanici_adi" name="kullanici_adi" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="sifre">Şifre</label>
                        <input type="password" id="sifre" name="sifre" required>
                    </div>
                    
                    <div class="form-group">
                        <button type="submit" class="btn btn-primary">Giriş Yap</button>
                    </div>
                </form>
                
                <div class="auth-links">
                    <a href="index.php">Ana sayfaya dön</a>
                </div>
            </div>
        </div>
    </main>
    
    <footer>
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> Şiir ve Alıntılar</p>
        </div>
    </footer>
    
    <script src="assets/js/main.js"></script>
</body>
</html> 