<?php
// Gerekli dosyaları dahil et
require_once 'config.php';
require_once 'includes/functions.php';

// Session başlat
session_start();

// Alıntıları getir (limit ile)
try {
    $alıntilar = $db->query("
        SELECT y.*, k.kategori_adi 
        FROM yazilar y
        LEFT JOIN yazi_kategori yk ON y.id = yk.yazi_id
        LEFT JOIN kategoriler k ON yk.kategori_id = k.id
        WHERE y.durum = 1
        ORDER BY y.eklenme_tarihi DESC
        LIMIT 12
    ")->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $alıntilar = [];
    uyariOlustur('Alıntılar getirilirken bir hata oluştu: ' . $e->getMessage(), 'danger');
}

// Öne çıkan kategorileri getir
try {
    $kategoriler = $db->query("
        SELECT k.*, COUNT(yk.yazi_id) as yazi_sayisi
        FROM kategoriler k
        LEFT JOIN yazi_kategori yk ON k.id = yk.kategori_id
        GROUP BY k.id
        ORDER BY yazi_sayisi DESC
        LIMIT 6
    ")->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $kategoriler = [];
    uyariOlustur('Kategoriler getirilirken bir hata oluştu: ' . $e->getMessage(), 'danger');
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Şiir ve Alıntılar</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <!-- Header -->
    <header>
        <div class="container">
            <div class="navbar">
                <div class="logo">
                    <h1><a href="index.php">Şiir ve Alıntılar</a></h1>
                </div>
                <button class="mobile-menu-toggle">
                    <span></span>
                    <span></span>
                    <span></span>
                </button>
                <ul class="nav-menu">
                    <li><a href="index.php" class="active">Ana Sayfa</a></li>
                    <li><a href="kategoriler.php">Kategoriler</a></li>
                    <?php if (isset($_SESSION['kullanici_id']) && isset($_SESSION['kullanici_yetki']) && $_SESSION['kullanici_yetki'] == 'admin'): ?>
                        <li><a href="admin/index.php">Yönetim Paneli</a></li>
                        <li><a href="cikis.php">Çıkış Yap</a></li>
                    <?php else: ?>
                        <li><a href="giris.php">Yönetici Girişi</a></li>
                    <?php endif; ?>
                </ul>
            </div>
            
            <!-- Arama Formu -->
            <div class="search-form">
                <form action="arama.php" method="get">
                    <input type="text" name="q" placeholder="Alıntı, şiir veya yazar ara..." required>
                    <button type="submit">Ara</button>
                </form>
            </div>
        </div>
    </header>
    
    <!-- Ana İçerik -->
    <main>
        <div class="container">
            <?php uyariGoster(); ?>
            
            <!-- Üst Bölüm -->
            <div class="hero-section">
                <h2>Şiir ve Alıntılarla Hayata Anlam Katan Cümleler</h2>
                <p>Şiirler, alıntılar ve özlü sözlerle duyguları keşfedin.</p>
            </div>
            
            <!-- Alıntılar - Kart Yapısı -->
            <section class="alinti-section">
                <h3 class="section-title">Alıntılar</h3>
                
                <?php if (count($alıntilar) > 0): ?>
                    <div class="alinti-cards">
                        <?php foreach ($alıntilar as $alinti): ?>
                            <div class="alinti-card">
                                <div class="alinti-card-header">
                                    <h3><?php echo $alinti['baslik']; ?></h3>
                                </div>
                                <div class="alinti-card-body">
                                    <div class="alinti-content">
                                        "<?php echo kisaMetin($alinti['icerik'], 200); ?>"
                                    </div>
                                    <div class="alinti-card-actions">
                                        <a href="alinti.php?id=<?php echo $alinti['id']; ?>" class="btn">Devamını Oku</a>
                                    </div>
                                </div>
                                <div class="alinti-card-footer">
                                    <div class="alinti-yazar">
                                        <?php if (!empty($alinti['yazar'])): ?>
                                            - <?php echo $alinti['yazar']; ?>
                                        <?php else: ?>
                                            - Anonim
                                        <?php endif; ?>
                                    </div>
                                    <div class="alinti-category">
                                        <?php if (!empty($alinti['kategori_adi'])): ?>
                                            <a href="kategori.php?id=<?php echo $alinti['id']; ?>"><?php echo $alinti['kategori_adi']; ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info">
                        Henüz hiç alıntı eklenmemiş.
                    </div>
                <?php endif; ?>
            </section>
            
            <!-- Öne Çıkan Kategoriler -->
            <section class="features">
                <h3 class="section-title">Öne Çıkan Kategoriler</h3>
                <div class="category-grid">
                    <?php foreach ($kategoriler as $kategori): ?>
                        <a href="kategori.php?id=<?php echo $kategori['id']; ?>" class="category-card">
                            <div class="category-icon">📚</div>
                            <h4><?php echo $kategori['kategori_adi']; ?></h4>
                            <p><?php echo $kategori['yazi_sayisi']; ?> Alıntı</p>
                            <?php if (!empty($kategori['aciklama'])): ?>
                                <div class="category-description">
                                    <?php echo kisaMetin($kategori['aciklama'], 70); ?>
                                </div>
                            <?php endif; ?>
                        </a>
                    <?php endforeach; ?>
                </div>
            </section>
        </div>
    </main>
    
    <!-- Footer -->
    <footer>
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> Şiir ve Alıntılar</p>
        </div>
    </footer>
    
    <script src="assets/js/main.js"></script>
</body>
</html> 