<?php
// Header'ı dahil et
require_once 'includes/header.php';

// ID parametresi kontrolü
if (!isset($_GET['id']) || empty($_GET['id'])) {
    uyariOlustur('Geçersiz kategori ID\'si!', 'danger');
    header('Location: kategoriler.php');
    exit;
}

$id = (int)$_GET['id'];

// Kategori bilgilerini getir
try {
    $stmt = $db->prepare("SELECT * FROM kategoriler WHERE id = :id");
    $stmt->bindParam(':id', $id);
    $stmt->execute();
    $kategori = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$kategori) {
        uyariOlustur('Kategori bulunamadı!', 'danger');
        header('Location: kategoriler.php');
        exit;
    }
} catch (PDOException $e) {
    uyariOlustur('Kategori bilgileri getirilirken bir hata oluştu!', 'danger');
    header('Location: kategoriler.php');
    exit;
}

// Sayfalama için değişkenler
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$limit = 9; // Her sayfada gösterilecek alıntı sayısı

// Toplam alıntı sayısı
$toplamYazi = toplamYaziSayisi($db, $id);
$toplamSayfa = ceil($toplamYazi / $limit);

// Sayfa kontrolü
if ($sayfa < 1) $sayfa = 1;
if ($sayfa > $toplamSayfa && $toplamSayfa > 0) $sayfa = $toplamSayfa;

// Kategoriye ait alıntıları getir
$yazilar = alinitilariGetir($db, $limit, $sayfa, $id);
?>

<!-- Kategori Detay Sayfası -->
<div class="kategori-detay-header">
    <h1 class="sayfa-baslik"><?php echo $kategori['kategori_adi']; ?></h1>
    
    <?php if (!empty($kategori['aciklama'])): ?>
        <p class="kategori-aciklama"><?php echo $kategori['aciklama']; ?></p>
    <?php endif; ?>
    
    <p class="kategori-bilgi">
        Bu kategoride toplam <strong><?php echo $toplamYazi; ?></strong> alıntı bulunuyor.
    </p>
    
    <a href="kategoriler.php" class="btn">&laquo; Tüm Kategorilere Dön</a>
</div>

<!-- Alıntılar Bölümü -->
<?php if (count($yazilar) > 0): ?>
    <section class="yazilar-container">
        <?php foreach ($yazilar as $yazi): ?>
            <div class="yazi-card">
                <div class="yazi-card-header">
                    <h3><?php echo $yazi['baslik']; ?></h3>
                </div>
                <div class="yazi-card-body">
                    <div class="yazi-card-content"><?php echo kisaMetin($yazi['icerik'], 200); ?></div>
                    <a href="alinti.php?id=<?php echo $yazi['id']; ?>" class="btn">Devamını Oku</a>
                </div>
                <div class="yazi-card-footer">
                    <div class="yazi-yazar"><?php echo $yazi['yazar'] ?: 'Anonim'; ?></div>
                    <div class="yazi-tarih"><?php echo tarihFormat($yazi['eklenme_tarihi']); ?></div>
                </div>
            </div>
        <?php endforeach; ?>
    </section>
    
    <!-- Sayfalama -->
    <?php if ($toplamSayfa > 1): ?>
        <div class="sayfalama-container">
            <?php echo sayfalama($toplamSayfa, $sayfa, "kategori.php?id={$id}"); ?>
        </div>
    <?php endif; ?>
<?php else: ?>
    <div class="alert alert-info">
        Bu kategoride henüz hiç alıntı eklenmemiş.
    </div>
<?php endif; ?>

<style>
    .kategori-detay-header {
        margin-bottom: 2rem;
        text-align: center;
    }
    
    .sayfa-baslik {
        color: var(--secondary-color);
        margin-bottom: 1rem;
    }
    
    .kategori-aciklama {
        color: #666;
        margin-bottom: 1rem;
        max-width: 800px;
        margin-left: auto;
        margin-right: auto;
    }
    
    .kategori-bilgi {
        margin-bottom: 1.5rem;
        font-style: italic;
    }
</style>

<?php
// Footer'ı dahil et
require_once 'includes/footer.php';
?> 