<?php
// Gerekli dosyaları dahil et
require_once 'config.php';
require_once 'includes/functions.php';

// Session başlat
session_start();

// Tüm kategorileri getir
try {
    $kategoriler = $db->query("
        SELECT k.*, COUNT(yk.yazi_id) as yazi_sayisi
        FROM kategoriler k
        LEFT JOIN yazi_kategori yk ON k.id = yk.kategori_id
        GROUP BY k.id
        ORDER BY k.kategori_adi ASC
    ")->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $kategoriler = [];
    uyariOlustur('Kategoriler getirilirken bir hata oluştu: ' . $e->getMessage(), 'danger');
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kategoriler - Şiir ve Alıntılar</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <!-- Header -->
    <header>
        <div class="container">
            <div class="navbar">
                <div class="logo">
                    <h1><a href="index.php">Şiir ve Alıntılar</a></h1>
                </div>
                <button class="mobile-menu-toggle">
                    <span></span>
                    <span></span>
                    <span></span>
                </button>
                <ul class="nav-menu">
                    <li><a href="index.php">Ana Sayfa</a></li>
                    <li><a href="kategoriler.php" class="active">Kategoriler</a></li>
                    <?php if (isset($_SESSION['kullanici_id']) && isset($_SESSION['kullanici_yetki']) && $_SESSION['kullanici_yetki'] == 'admin'): ?>
                        <li><a href="admin/index.php">Yönetim Paneli</a></li>
                        <li><a href="cikis.php">Çıkış Yap</a></li>
                    <?php else: ?>
                        <li><a href="giris.php">Yönetici Girişi</a></li>
                    <?php endif; ?>
                </ul>
            </div>
            
            <!-- Arama Formu -->
            <div class="search-form">
                <form action="arama.php" method="get">
                    <input type="text" name="q" placeholder="Alıntı, şiir veya yazar ara..." required>
                    <button type="submit">Ara</button>
                </form>
            </div>
        </div>
    </header>
    
    <!-- Ana İçerik -->
    <main>
        <div class="container">
            <?php uyariGoster(); ?>
            
            <!-- Başlık -->
            <div class="page-header">
                <h2>Tüm Kategoriler</h2>
                <p>Alıntıları kategorilere göre keşfedin.</p>
            </div>
            
            <!-- Kategoriler -->
            <div class="category-container">
                <?php if (count($kategoriler) > 0): ?>
                    <div class="category-grid">
                        <?php foreach ($kategoriler as $kategori): ?>
                            <div class="category-card">
                                <div class="category-header">
                                    <div class="category-icon">📚</div>
                                    <h3 class="category-title"><?php echo $kategori['kategori_adi']; ?></h3>
                                </div>
                                <div class="category-body">
                                    <?php if (!empty($kategori['aciklama'])): ?>
                                        <div class="category-description">
                                            <?php echo kisaMetin($kategori['aciklama'], 120); ?>
                                        </div>
                                    <?php else: ?>
                                        <div class="category-description">
                                            Bu kategoriyle ilgili alıntıları keşfedin.
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="category-count">
                                        <?php echo $kategori['yazi_sayisi']; ?> alıntı bulunuyor
                                    </div>
                                    
                                    <div class="category-btn">
                                        <a href="kategori.php?id=<?php echo $kategori['id']; ?>" class="btn">Alıntıları Görüntüle</a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info">
                        Henüz hiç kategori eklenmemiş.
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>
    
    <!-- Footer -->
    <footer>
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> Şiir ve Alıntılar</p>
        </div>
    </footer>
    
    <script src="assets/js/main.js"></script>
</body>
</html> 