<?php
// Oturum ve gerekli dosyaları dahil et
require_once '../inc/autoload.php';

// Admin sınıfını başlat
$admin = new Admin($conn);

// Site ayarlarını al
$settings = getSiteSettings($conn);

// Admin girişi kontrolü
if (!$admin->isLoggedIn()) {
    header("Location: login.php");
    exit;
}

// Sayfa başlığını ayarla
$pageTitle = getPageTitle('Şifre Değiştir', $conn);

// Hata ve başarı mesajlarını saklamak için değişkenler
$message = '';
$messageType = '';

// Form submit edildi mi kontrol et
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF token kontrolü
    if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        $message = "Güvenlik doğrulaması başarısız! Lütfen sayfayı yenileyip tekrar deneyin.";
        $messageType = 'danger';
    } else {
        // Formdaki verileri al
        $currentPassword = isset($_POST['current_password']) ? $_POST['current_password'] : '';
        $newPassword = isset($_POST['new_password']) ? $_POST['new_password'] : '';
        $confirmPassword = isset($_POST['confirm_password']) ? $_POST['confirm_password'] : '';
        
        // Şifre değiştirme işlemini çağır
        $result = $admin->changePassword($currentPassword, $newPassword, $confirmPassword);
        
        // Sonucu göster
        if ($result['success']) {
            $message = $result['message'];
            $messageType = 'success';
            
            // Formları temizle (başarılı ise)
            $currentPassword = '';
            $newPassword = '';
            $confirmPassword = '';
        } else {
            $message = $result['message'];
            $messageType = 'danger';
        }
    }
}

// Yeni CSRF token oluştur
$_SESSION['csrf_token'] = bin2hex(random_bytes(32));
?>

<?php include 'includes/header.php'; ?>

<div class="container-fluid py-4">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-key me-2"></i>Şifre Değiştir</h5>
                </div>
                <div class="card-body">
                    <?php if (!empty($message)): ?>
                    <div class="alert alert-<?php echo $messageType; ?> alert-dismissible fade show" role="alert">
                        <?php echo $message; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>
                    
                    <form method="post" action="">
                        <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                        
                        <div class="mb-3">
                            <label for="current_password" class="form-label">Mevcut Şifre</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-lock"></i></span>
                                <input type="password" class="form-control" id="current_password" name="current_password" required>
                            </div>
                            <div class="form-text">Mevcut şifrenizi girin.</div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="new_password" class="form-label">Yeni Şifre</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-key"></i></span>
                                <input type="password" class="form-control" id="new_password" name="new_password" required>
                                <button class="btn btn-outline-secondary" type="button" id="toggleNewPassword">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            <div class="form-text">En az 8 karakter uzunluğunda olmalıdır.</div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="confirm_password" class="form-label">Yeni Şifre (Tekrar)</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-key"></i></span>
                                <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                                <button class="btn btn-outline-secondary" type="button" id="toggleConfirmPassword">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            <div class="form-text">Yeni şifrenizi tekrar girin.</div>
                        </div>
                        
                        <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>Şifreyi Değiştir
                            </button>
                            <a href="index.php" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>İptal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Şifre görünürlüğünü değiştirme
    document.getElementById('toggleNewPassword').addEventListener('click', function() {
        const passwordField = document.getElementById('new_password');
        const icon = this.querySelector('i');
        
        if (passwordField.type === 'password') {
            passwordField.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            passwordField.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    });
    
    document.getElementById('toggleConfirmPassword').addEventListener('click', function() {
        const passwordField = document.getElementById('confirm_password');
        const icon = this.querySelector('i');
        
        if (passwordField.type === 'password') {
            passwordField.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            passwordField.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    });
    
    // Form submit öncesi şifre gücünü kontrol et
    document.querySelector('form').addEventListener('submit', function(event) {
        const newPassword = document.getElementById('new_password').value;
        const confirmPassword = document.getElementById('confirm_password').value;
        
        // Şifre eşleşmesi kontrolü
        if (newPassword !== confirmPassword) {
            event.preventDefault();
            alert('Yeni şifre ve onay şifresi eşleşmiyor!');
            return false;
        }
        
        // Şifre uzunluğu kontrolü
        if (newPassword.length < 8) {
            event.preventDefault();
            alert('Şifre en az 8 karakter uzunluğunda olmalıdır!');
            return false;
        }
        
        return true;
    });
</script>

<?php include 'includes/footer.php'; ?> 