<?php
// Gerekli dosyaları include et
require_once '../inc/autoload.php';

// Admin sınıfını başlat
$admin = new Admin($conn);

// Site ayarlarını al
$settings = getSiteSettings($conn);

// Sayfa başlığını ayarla
$pageTitle = getPageTitle('Admin Paneli', $conn);

// Aktif sayfa
$active_page = 'dashboard';

// Kullanıcı istatistikleri
$users = $admin->listUsers();
$userCount = count($users);

// Fotoğraf istatistikleri
$photos = $admin->listPhotos();
$photoCount = count($photos);

// Son yüklenen fotoğraflar (ilk 5)
$recentPhotos = array_slice($photos, 0, 5);

// Header'ı dahil et
include 'includes/header.php';
?>

<!-- Dashboard İçeriği -->
<div class="row mb-4">
    <div class="col-12">
        <h2 class="mb-4"><i class="fas fa-tachometer-alt me-2"></i>Dashboard</h2>
    </div>
</div>

<!-- İstatistik Kartları -->
<div class="row g-4 mb-4">
    <div class="col-md-6 col-lg-3">
        <div class="card admin-card h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted text-uppercase">Toplam Fotoğraf</h6>
                        <h1 class="mt-2"><?php echo $photoCount; ?></h1>
                    </div>
                    <div class="bg-primary text-white p-3 rounded">
                        <i class="fas fa-images fa-2x"></i>
                    </div>
                </div>
                <a href="photos.php" class="text-decoration-none d-inline-block mt-3">
                    <span class="text-primary">Fotoğrafları Görüntüle</span>
                    <i class="fas fa-arrow-right ms-1"></i>
                </a>
            </div>
        </div>
    </div>
    
    <div class="col-md-6 col-lg-3">
        <div class="card admin-card card-success h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted text-uppercase">Toplam Kullanıcı</h6>
                        <h1 class="mt-2"><?php echo $userCount; ?></h1>
                    </div>
                    <div class="bg-success text-white p-3 rounded">
                        <i class="fas fa-users fa-2x"></i>
                    </div>
                </div>
                <a href="users.php" class="text-decoration-none d-inline-block mt-3">
                    <span class="text-success">Kullanıcıları Görüntüle</span>
                    <i class="fas fa-arrow-right ms-1"></i>
                </a>
            </div>
        </div>
    </div>
    
    <div class="col-md-6 col-lg-3">
        <div class="card admin-card card-warning h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted text-uppercase">Kullanıcısız Fotoğraflar</h6>
                        <?php 
                        $anonymousCount = 0;
                        foreach ($photos as $photo) {
                            if ($photo['user_id'] === null) {
                                $anonymousCount++;
                            }
                        }
                        ?>
                        <h1 class="mt-2"><?php echo $anonymousCount; ?></h1>
                    </div>
                    <div class="bg-warning text-white p-3 rounded">
                        <i class="fas fa-user-times fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6 col-lg-3">
        <div class="card admin-card card-info h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted text-uppercase">Site Durumu</h6>
                        <h3 class="mt-2">Aktif</h3>
                    </div>
                    <div class="bg-info text-white p-3 rounded">
                        <i class="fas fa-check-circle fa-2x"></i>
                    </div>
                </div>
                <a href="settings.php" class="text-decoration-none d-inline-block mt-3">
                    <span class="text-info">Ayarları Düzenle</span>
                    <i class="fas fa-arrow-right ms-1"></i>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Son Yüklenen Fotoğraflar -->
<div class="row mb-4">
    <div class="col-lg-8">
        <div class="card shadow-sm">
            <div class="card-header bg-white">
                <h5 class="mb-0"><i class="fas fa-images me-2"></i>Son Yüklenen Fotoğraflar</h5>
            </div>
            <div class="card-body">
                <?php if (count($recentPhotos) > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th width="80">Önizleme</th>
                                <th>Dosya Adı</th>
                                <th>Kullanıcı</th>
                                <th>Tarih</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recentPhotos as $photo): ?>
                            <tr>
                                <td>
                                    <img src="../<?php echo $photo['file_url']; ?>" alt="Thumbnail" width="60" height="60" class="img-thumbnail">
                                </td>
                                <td><?php echo sanitize($photo['original_name']); ?></td>
                                <td>
                                    <?php if ($photo['username']): ?>
                                    <?php echo sanitize($photo['username']); ?>
                                    <?php else: ?>
                                    <span class="badge bg-secondary">Ziyaretçi</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo date('d.m.Y H:i', strtotime($photo['created_at'])); ?></td>
                                <td>
                                    <a href="../<?php echo $photo['file_url']; ?>" class="btn btn-sm btn-primary" target="_blank" title="Görüntüle">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="photos.php?delete=<?php echo $photo['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu fotoğrafı silmek istediğinize emin misiniz?')" title="Sil">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <a href="photos.php" class="btn btn-primary">Tüm Fotoğrafları Görüntüle</a>
                <?php else: ?>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i> Henüz hiç fotoğraf yüklenmemiş.
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card shadow-sm">
            <div class="card-header bg-white">
                <h5 class="mb-0"><i class="fas fa-cog me-2"></i>Hızlı Ayarlar</h5>
            </div>
            <div class="card-body">
                <div class="list-group">
                    <a href="settings.php" class="list-group-item list-group-item-action">
                        <div class="d-flex w-100 justify-content-between">
                            <h6 class="mb-1"><i class="fas fa-globe me-2"></i>Site Başlığı</h6>
                        </div>
                        <p class="mb-1"><?php echo sanitize($settings['site_title']); ?></p>
                    </a>
                    <a href="settings.php" class="list-group-item list-group-item-action">
                        <div class="d-flex w-100 justify-content-between">
                            <h6 class="mb-1"><i class="fas fa-info-circle me-2"></i>Site Açıklaması</h6>
                        </div>
                        <p class="mb-1"><?php echo sanitize($settings['site_description']); ?></p>
                    </a>
                    <a href="settings.php" class="list-group-item list-group-item-action">
                        <div class="d-flex w-100 justify-content-between">
                            <h6 class="mb-1"><i class="fas fa-tag me-2"></i>Anahtar Kelimeler</h6>
                        </div>
                        <p class="mb-1"><?php echo sanitize($settings['site_keywords']); ?></p>
                    </a>
                    <a href="settings.php" class="list-group-item list-group-item-action">
                        <div class="d-flex w-100 justify-content-between">
                            <h6 class="mb-1"><i class="fas fa-ad me-2"></i>AdSense Kodu</h6>
                        </div>
                        <p class="mb-1">
                            <?php if (!empty($settings['adsense_code'])): ?>
                            <span class="badge bg-success">Ayarlandı</span>
                            <?php else: ?>
                            <span class="badge bg-warning text-dark">Ayarlanmadı</span>
                            <?php endif; ?>
                        </p>
                    </a>
                    <a href="settings.php" class="list-group-item list-group-item-action">
                        <div class="d-flex w-100 justify-content-between">
                            <h6 class="mb-1"><i class="fas fa-chart-line me-2"></i>Analytics Kodu</h6>
                        </div>
                        <p class="mb-1">
                            <?php if (!empty($settings['analytics_code'])): ?>
                            <span class="badge bg-success">Ayarlandı</span>
                            <?php else: ?>
                            <span class="badge bg-warning text-dark">Ayarlanmadı</span>
                            <?php endif; ?>
                        </p>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
// Footer'ı dahil et
include 'includes/footer.php';
?> 