<?php
// Gerekli dosyaları include et
require_once '../inc/autoload.php';

// Admin sınıfını başlat
$admin = new Admin($conn);

// Site ayarlarını al
$settings = getSiteSettings($conn);

// Sayfa başlığını ayarla
$pageTitle = getPageTitle('Fotoğraflar', $conn);

// Aktif sayfa
$active_page = 'photos';

// Hata ve başarı mesajları
$message = '';
$messageType = '';

// Fotoğraf silme işlemi
if (isset($_GET['delete']) && !empty($_GET['delete'])) {
    $photoId = (int) $_GET['delete'];
    $result = $admin->deletePhoto($photoId);
    
    if ($result['success']) {
        $message = $result['message'];
        $messageType = 'success';
    } else {
        $message = $result['message'];
        $messageType = 'danger';
    }
}

// Fotoğrafları listele
$photos = $admin->listPhotos();

// Header'ı dahil et
include 'includes/header.php';
?>

<!-- Photos İçeriği -->
<div class="row mb-4">
    <div class="col-12 d-flex justify-content-between align-items-center">
        <h2 class="mb-0"><i class="fas fa-images me-2"></i>Fotoğraflar</h2>
        <span class="badge bg-primary fs-6"><?php echo count($photos); ?> Fotoğraf</span>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card shadow-sm">
            <div class="card-header bg-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Tüm Fotoğraflar</h5>
                <form class="d-flex" id="searchForm">
                    <input class="form-control me-2" type="search" placeholder="Dosya adı ara..." id="searchInput">
                    <button class="btn btn-outline-primary" type="submit">
                        <i class="fas fa-search"></i>
                    </button>
                </form>
            </div>
            <div class="card-body">
                <?php if (count($photos) > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover" id="photosTable">
                        <thead>
                            <tr>
                                <th width="80">Önizleme</th>
                                <th>Dosya Adı</th>
                                <th>Tür</th>
                                <th>Boyut</th>
                                <th>Kullanıcı</th>
                                <th>Tarih</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($photos as $photo): ?>
                            <tr>
                                <td>
                                    <img src="../<?php echo $photo['file_url']; ?>" alt="Thumbnail" width="60" height="60" class="img-thumbnail">
                                </td>
                                <td><?php echo sanitize($photo['original_name']); ?></td>
                                <td><?php echo strtoupper($photo['file_type']); ?></td>
                                <td><?php echo formatFileSize($photo['file_size']); ?></td>
                                <td>
                                    <?php if ($photo['username']): ?>
                                    <a href="users.php"><?php echo sanitize($photo['username']); ?></a>
                                    <?php else: ?>
                                    <span class="badge bg-secondary">Ziyaretçi</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo date('d.m.Y H:i', strtotime($photo['created_at'])); ?></td>
                                <td>
                                    <a href="../<?php echo $photo['file_url']; ?>" class="btn btn-sm btn-primary" target="_blank" title="Görüntüle">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="../<?php echo $photo['file_url']; ?>" class="btn btn-sm btn-success" download title="İndir">
                                        <i class="fas fa-download"></i>
                                    </a>
                                    <a href="photos.php?delete=<?php echo $photo['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu fotoğrafı silmek istediğinize emin misiniz?')" title="Sil">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i> Henüz hiç fotoğraf yüklenmemiş.
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php 
// JavaScript kodu
$custom_js = <<<EOT
// Arama işlevselliği
document.getElementById('searchForm').addEventListener('submit', function(e) {
    e.preventDefault();
    const searchValue = document.getElementById('searchInput').value.toLowerCase();
    const table = document.getElementById('photosTable');
    const rows = table.querySelectorAll('tbody tr');
    
    rows.forEach(row => {
        const fileName = row.querySelector('td:nth-child(2)').textContent.toLowerCase();
        if (fileName.includes(searchValue)) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
});

// Anlık arama
document.getElementById('searchInput').addEventListener('keyup', function() {
    const searchValue = this.value.toLowerCase();
    const table = document.getElementById('photosTable');
    const rows = table.querySelectorAll('tbody tr');
    
    rows.forEach(row => {
        const fileName = row.querySelector('td:nth-child(2)').textContent.toLowerCase();
        if (fileName.includes(searchValue)) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
});
EOT;

// Footer'ı dahil et
include 'includes/footer.php';
?>