<?php
// Gerekli dosyaları include et
require_once '../inc/autoload.php';

// Admin sınıfını başlat
$admin = new Admin($conn);

// Site ayarlarını al
$settings = getSiteSettings($conn);

// Sayfa başlığını ayarla
$pageTitle = getPageTitle('Kullanıcılar', $conn);

// Aktif sayfa
$active_page = 'users';

// Hata ve başarı mesajları
$message = '';
$messageType = '';

// Kullanıcı silme işlemi
if (isset($_GET['delete']) && !empty($_GET['delete'])) {
    $userId = (int) $_GET['delete'];
    $result = $admin->deleteUser($userId);
    
    if ($result['success']) {
        $message = $result['message'];
        $messageType = 'success';
    } else {
        $message = $result['message'];
        $messageType = 'danger';
    }
}

// Kullanıcıları listele
$users = $admin->listUsers();

// Header'ı dahil et
include 'includes/header.php';
?>

<!-- Users İçeriği -->
<div class="row mb-4">
    <div class="col-12 d-flex justify-content-between align-items-center">
        <h2 class="mb-0"><i class="fas fa-users me-2"></i>Kullanıcılar</h2>
        <span class="badge bg-primary fs-6"><?php echo count($users); ?> Kullanıcı</span>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card shadow-sm">
            <div class="card-header bg-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Tüm Kullanıcılar</h5>
                <form class="d-flex" id="searchForm">
                    <input class="form-control me-2" type="search" placeholder="Kullanıcı ara..." id="searchInput">
                    <button class="btn btn-outline-primary" type="submit">
                        <i class="fas fa-search"></i>
                    </button>
                </form>
            </div>
            <div class="card-body">
                <?php if (count($users) > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover" id="usersTable">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Kullanıcı Adı</th>
                                <th>E-posta</th>
                                <th>Kayıt Tarihi</th>
                                <th>Fotoğraflar</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users as $index => $user): ?>
                            <?php 
                                // Kullanıcının fotoğraflarını say
                                $userPhotos = (new User($conn))->getUserPhotos($user['id']);
                                $photoCount = count($userPhotos);
                            ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td><?php echo sanitize($user['username']); ?></td>
                                <td><?php echo sanitize($user['email']); ?></td>
                                <td><?php echo date('d.m.Y H:i', strtotime($user['created_at'])); ?></td>
                                <td>
                                    <span class="badge bg-info"><?php echo $photoCount; ?> Fotoğraf</span>
                                </td>
                                <td>
                                    <a href="users.php?delete=<?php echo $user['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu kullanıcıyı silmek istediğinize emin misiniz? Kullanıcıya ait tüm fotoğraflar da silinecektir!')" title="Sil">
                                        <i class="fas fa-trash"></i> Sil
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i> Henüz hiç kullanıcı kaydı yok.
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php 
// JavaScript kodu
$custom_js = <<<EOT
// Arama işlevselliği
document.getElementById('searchForm').addEventListener('submit', function(e) {
    e.preventDefault();
    const searchValue = document.getElementById('searchInput').value.toLowerCase();
    const table = document.getElementById('usersTable');
    const rows = table.querySelectorAll('tbody tr');
    
    rows.forEach(row => {
        const username = row.querySelector('td:nth-child(2)').textContent.toLowerCase();
        const email = row.querySelector('td:nth-child(3)').textContent.toLowerCase();
        
        if (username.includes(searchValue) || email.includes(searchValue)) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
});

// Anlık arama
document.getElementById('searchInput').addEventListener('keyup', function() {
    const searchValue = this.value.toLowerCase();
    const table = document.getElementById('usersTable');
    const rows = table.querySelectorAll('tbody tr');
    
    rows.forEach(row => {
        const username = row.querySelector('td:nth-child(2)').textContent.toLowerCase();
        const email = row.querySelector('td:nth-child(3)').textContent.toLowerCase();
        
        if (username.includes(searchValue) || email.includes(searchValue)) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
});
EOT;

// Footer'ı dahil et
include 'includes/footer.php';
?> 