-- Veritabanı oluşturma
CREATE DATABASE IF NOT EXISTS fotoupload;
USE fotoupload;

-- Kullanıcılar tablosu
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    email VARCHAR(100) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    created_at DATETIME NOT NULL
);

-- Fotoğraflar tablosu
CREATE TABLE IF NOT EXISTS photos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    file_name VARCHAR(255) NOT NULL,
    original_name VARCHAR(255) NOT NULL,
    file_type VARCHAR(10) NOT NULL,
    file_size INT NOT NULL,
    file_url VARCHAR(255) NOT NULL,
    user_id INT NULL,
    created_at DATETIME NOT NULL,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL
);

-- Admin tablosu
CREATE TABLE IF NOT EXISTS admin (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL
);

-- Site ayarları tablosu
CREATE TABLE IF NOT EXISTS settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    site_title VARCHAR(100) NOT NULL,
    site_description TEXT,
    site_keywords TEXT,
    adsense_code TEXT,
    analytics_code TEXT,
    contact_email VARCHAR(100),
    contact_phone VARCHAR(20),
    contact_address TEXT,
    contact_website VARCHAR(100)
);

-- Varsayılan admin kullanıcısı (şifre: admin123)
INSERT INTO admin (username, password) VALUES ('admin', '$2y$10$h9ejqPNEHZZARhYuJvi4b.tjv3IWPgGY5og3EZRuRx8glsi2bVV46');

-- Varsayılan site ayarları
INSERT INTO settings (id, site_title, site_description, site_keywords, contact_email, contact_website) 
VALUES (1, 'Fotoğraf Upload Sitesi', 'Fotoğraflarınızı hızlı ve kolay bir şekilde yükleyin', 'fotoğraf, upload, yükleme, paylaşım', 'iletisim@example.com', 'www.example.com'); 