<?php
// Veritabanı bağlantısı
require_once __DIR__ . '/../config/database.php';

// Fonksiyonlar
require_once __DIR__ . '/functions.php';

// Sınıflar
spl_autoload_register(function ($className) {
    $file = __DIR__ . '/classes/' . $className . '.php';
    if (file_exists($file)) {
        require_once $file;
    }
});

// Site ayarlarını al
function getSiteSettings($conn) {
    // SQL enjeksiyonuna karşı prepared statement kullan
    $sql = "SELECT * FROM settings WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    
    if (!$stmt) {
        error_log("Prepared statement oluşturma hatası: " . mysqli_error($conn));
        return getDefaultSettings();
    }
    
    mysqli_stmt_bind_param($stmt, "i", $id);
    $id = 1; // İlk ve tek ayar kaydı
    
    if (!mysqli_stmt_execute($stmt)) {
        error_log("Settings sorgulama hatası: " . mysqli_stmt_error($stmt));
        mysqli_stmt_close($stmt);
        return getDefaultSettings();
    }
    
    $result = mysqli_stmt_get_result($stmt);
    
    if (mysqli_num_rows($result) > 0) {
        $settings = mysqli_fetch_assoc($result);
        mysqli_stmt_close($stmt);
        return $settings;
    }
    
    mysqli_stmt_close($stmt);
    return getDefaultSettings();
}

// Varsayılan ayarları döndür
function getDefaultSettings() {
    return array(
        'site_title' => 'Fotoğraf Upload Sitesi',
        'site_description' => 'Fotoğraflarınızı hızlı ve kolay bir şekilde yükleyin',
        'site_keywords' => 'fotoğraf, upload, yükleme, paylaşım',
        'adsense_code' => '',
        'analytics_code' => '',
        'contact_email' => 'iletisim@example.com',
        'contact_phone' => '',
        'contact_address' => '',
        'contact_website' => 'www.example.com'
    );
}

// Sayfa başlığını oluştur
function getPageTitle($title = '', $conn = null) {
    if ($conn) {
        $settings = getSiteSettings($conn);
        if (!empty($title)) {
            return $title . ' - ' . $settings['site_title'];
        }
        return $settings['site_title'];
    }
    
    if (!empty($title)) {
        return $title . ' - Fotoğraf Upload Sitesi';
    }
    return 'Fotoğraf Upload Sitesi';
}
?> 