<?php
// Oturum başlatma
session_start();

// Oturum kontrolü
function checkLogin() {
    if (!isset($_SESSION['user_id'])) {
        return false;
    }
    return true;
}

// Kullanıcı bilgilerini getir
function getUserInfo($userId, $conn) {
    $sql = "SELECT * FROM users WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "i", $userId);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    
    if (mysqli_num_rows($result) > 0) {
        return mysqli_fetch_assoc($result);
    }
    
    return false;
}

// URL güvenliği
function cleanURL($string) {
    $string = preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
    $string = strtolower(trim($string, '-'));
    return $string;
}

// Dosya boyutunu insanların okuyabileceği formata dönüştürme
function formatFileSize($bytes) {
    if ($bytes >= 1073741824) {
        $bytes = number_format($bytes / 1073741824, 2) . ' GB';
    } elseif ($bytes >= 1048576) {
        $bytes = number_format($bytes / 1048576, 2) . ' MB';
    } elseif ($bytes >= 1024) {
        $bytes = number_format($bytes / 1024, 2) . ' KB';
    } elseif ($bytes > 1) {
        $bytes = $bytes . ' bytes';
    } elseif ($bytes == 1) {
        $bytes = $bytes . ' byte';
    } else {
        $bytes = '0 bytes';
    }
    return $bytes;
}

// Rastgele dosya adı oluşturma
function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

// XSS koruması
function sanitize($data) {
    if (is_array($data)) {
        foreach ($data as $key => $value) {
            $data[$key] = sanitize($value);
        }
        return $data;
    }
    
    // Null değerleri boş stringe çevir
    if ($data === null) {
        return '';
    }
    
    // String değilse stringe çevir
    if (!is_string($data)) {
        $data = strval($data);
    }
    
    // Özel karakterleri encode et
    $data = htmlspecialchars($data, ENT_QUOTES | ENT_HTML5, 'UTF-8');
    
    return $data;
}
?> 