<?php
// Gerekli dosyaları include et
require_once 'inc/autoload.php';

// Site ayarlarını al
$settings = getSiteSettings($conn);

// Fotoğraf sınıfını başlat
$photo = new Photo($conn);

// Hata ve başarı mesajları
$message = '';
$messageType = '';

// Fotoğraf yükleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Dosyadan yükleme
    if (isset($_FILES['file']) && !empty($_FILES['file']['name'])) {
        $userId = (isset($_SESSION['user_id'])) ? $_SESSION['user_id'] : null;
        $result = $photo->uploadFromFile($_FILES['file'], $userId);
        
        if ($result['success']) {
            // Başarılı yükleme sonrası yönlendirme
            header("Location: upload-success.php?id=" . $result['photo_id']);
            exit;
        } else {
            $message = $result['message'];
            $messageType = 'danger';
        }
    }
    
    // URL'den yükleme
    if (isset($_POST['url']) && !empty($_POST['url'])) {
        $userId = (isset($_SESSION['user_id'])) ? $_SESSION['user_id'] : null;
        $result = $photo->uploadFromUrl($_POST['url'], $userId);
        
        if ($result['success']) {
            // Başarılı yükleme sonrası yönlendirme
            header("Location: upload-success.php?id=" . $result['photo_id']);
            exit;
        } else {
            $message = $result['message'];
            $messageType = 'danger';
        }
    }
    
    // Base64'ten yükleme
    if (isset($_POST['data']) && !empty($_POST['data'])) {
        $userId = (isset($_SESSION['user_id'])) ? $_SESSION['user_id'] : null;
        $result = $photo->uploadFromData($_POST['data'], $userId);
        
        if ($result['success']) {
            // Başarılı yükleme sonrası yönlendirme
            header("Location: upload-success.php?id=" . $result['photo_id']);
            exit;
        } else {
            $message = $result['message'];
            $messageType = 'danger';
        }
    }
}

// Sayfa başlığını ayarla
$pageTitle = getPageTitle('', $conn);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo $settings['site_description']; ?>">
    <meta name="keywords" content="<?php echo $settings['site_keywords']; ?>">
    <title><?php echo $pageTitle; ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/style.css">
    
    <!-- Google Analytics -->
    <?php if (!empty($settings['analytics_code'])): ?>
    <?php echo $settings['analytics_code']; ?>
    <?php endif; ?>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-camera-retro me-2"></i><?php echo $settings['site_title']; ?>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link active" href="index.php"><i class="fas fa-home me-1"></i> Ana Sayfa</a>
                    </li>
                    <?php if (checkLogin()): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="profile.php"><i class="fas fa-user me-1"></i> Profilim</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="logout.php"><i class="fas fa-sign-out-alt me-1"></i> Çıkış Yap</a>
                    </li>
                    <?php else: ?>
                    <li class="nav-item">
                        <a class="nav-link" href="login.php"><i class="fas fa-sign-in-alt me-1"></i> Giriş Yap</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="register.php"><i class="fas fa-user-plus me-1"></i> Kayıt Ol</a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <div class="hero-section bg-light py-5 text-center">
        <div class="container">
            <h1 class="display-4 fw-bold text-primary">Fotoğraflarınızı Hızlıca Yükleyin</h1>
            <p class="lead">Bilgisayardan, URL'den veya direkt yapıştırarak fotoğraflarınızı kolayca yükleyin!</p>
            
            <?php if (!empty($message)): ?>
            <div class="alert alert-<?php echo $messageType; ?> alert-dismissible fade show mt-3" role="alert">
                <?php echo $message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>
            
            <!-- Upload Tabs -->
            <div class="card shadow mt-4">
                <div class="card-body">
                    <ul class="nav nav-tabs" id="uploadTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="file-tab" data-bs-toggle="tab" data-bs-target="#file" type="button" role="tab" aria-controls="file" aria-selected="true">
                                <i class="fas fa-desktop me-1"></i> Bilgisayardan Yükle
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="url-tab" data-bs-toggle="tab" data-bs-target="#url" type="button" role="tab" aria-controls="url" aria-selected="false">
                                <i class="fas fa-link me-1"></i> İnternetten Yükle
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="drag-tab" data-bs-toggle="tab" data-bs-target="#drag" type="button" role="tab" aria-controls="drag" aria-selected="false">
                                <i class="fas fa-hand-pointer me-1"></i> Sürükle & Bırak
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="paste-tab" data-bs-toggle="tab" data-bs-target="#paste" type="button" role="tab" aria-controls="paste" aria-selected="false">
                                <i class="fas fa-paste me-1"></i> Yapıştır & Yükle
                            </button>
                        </li>
                    </ul>
                    <div class="tab-content p-3" id="uploadTabsContent">
                        <!-- Dosyadan Yükleme -->
                        <div class="tab-pane fade show active" id="file" role="tabpanel" aria-labelledby="file-tab">
                            <form action="index.php" method="post" enctype="multipart/form-data">
                                <div class="mb-3">
                                    <label for="file" class="form-label">Dosya Seçin (JPG, JPEG, PNG, GIF - Maks. 5MB)</label>
                                    <input class="form-control" type="file" id="file" name="file" accept="image/jpeg,image/jpg,image/png,image/gif" required>
                                </div>
                                <button type="submit" class="btn btn-primary"><i class="fas fa-upload me-1"></i> Yükle</button>
                            </form>
                        </div>
                        
                        <!-- URL'den Yükleme -->
                        <div class="tab-pane fade" id="url" role="tabpanel" aria-labelledby="url-tab">
                            <form action="index.php" method="post">
                                <div class="mb-3">
                                    <label for="url" class="form-label">Görsel URL'si</label>
                                    <input type="url" class="form-control" id="url" name="url" placeholder="https://örnek.com/resim.jpg" required>
                                    <div class="form-text">Fotoğrafın internet adresini girin (JPG, JPEG, PNG, GIF - Maks. 5MB)</div>
                                </div>
                                <button type="submit" class="btn btn-primary"><i class="fas fa-download me-1"></i> URL'den Yükle</button>
                            </form>
                        </div>
                        
                        <!-- Sürükle & Bırak -->
                        <div class="tab-pane fade" id="drag" role="tabpanel" aria-labelledby="drag-tab">
                            <div class="dropzone-container mb-3 p-5 border border-dashed rounded text-center" id="dropzone">
                                <i class="fas fa-cloud-upload-alt fa-3x text-primary mb-3"></i>
                                <h4>Dosyaları buraya sürükleyip bırakın</h4>
                                <p class="text-muted">(JPG, JPEG, PNG, GIF - Maks. 5MB)</p>
                                <div id="dropzone-preview" class="mt-3"></div>
                            </div>
                        </div>
                        
                        <!-- Yapıştır & Yükle -->
                        <div class="tab-pane fade" id="paste" role="tabpanel" aria-labelledby="paste-tab">
                            <div class="text-center mb-3">
                                <div class="paste-container p-4 border rounded mb-3" id="pasteArea">
                                    <i class="far fa-clipboard fa-3x text-primary mb-3"></i>
                                    <h4>Bir görsel kopyalayın ve buraya tıklayıp Ctrl+V yapın</h4>
                                    <p class="text-muted">(Maks. 5MB)</p>
                                </div>
                                <div id="pastePreview" class="mt-3"></div>
                                <form action="index.php" method="post" id="pasteForm" style="display:none;">
                                    <input type="hidden" name="data" id="pasteData">
                                    <button type="submit" class="btn btn-primary mt-3"><i class="fas fa-paste me-1"></i> Yapıştırılan Görseli Yükle</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Sistem Hakkında Bilgi -->
    <div class="container py-5">
        <h2 class="mb-4 text-center"><i class="fas fa-info-circle me-2"></i>Sistem Hakkında</h2>
        
        <?php if (!empty($settings['adsense_code'])): ?>
        <!-- Reklam Alanı -->
        <div class="text-center mb-4">
            <?php echo $settings['adsense_code']; ?>
        </div>
        <?php endif; ?>
        
        <div class="row g-4">
            <div class="col-md-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center">
                        <i class="fas fa-cloud-upload-alt fa-4x text-primary mb-3"></i>
                        <h4>Kolay Yükleme</h4>
                        <p class="text-muted">Fotoğraflarınızı bilgisayardan yükleyebilir, URL ile ekleyebilir, sürükle-bırak yapabilir veya doğrudan yapıştırarak yükleyebilirsiniz.</p>
                        <p><span class="badge bg-primary">Dört Farklı Metod</span></p>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center">
                        <i class="fas fa-file-image fa-4x text-success mb-3"></i>
                        <h4>Çoklu Format Desteği</h4>
                        <p class="text-muted">Sitemiz jpg, jpeg, png ve gif dahil olmak üzere en yaygın fotoğraf formatlarını desteklemektedir. Her format için yüksek kaliteli görüntüleme sağlıyoruz.</p>
                        <p><span class="badge bg-success">Tüm Popüler Formatlar</span></p>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center">
                        <i class="fas fa-user-shield fa-4x text-danger mb-3"></i>
                        <h4>Üyelik Sistemi</h4>
                        <p class="text-muted">Ücretsiz hesap oluşturarak yüklediğiniz tüm fotoğrafları yönetebilirsiniz. Üye olmadan da yükleme yapabilirsiniz.</p>
                        <p><span class="badge bg-danger">Ücretsiz Kayıt</span></p>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row mt-5">
            <div class="col-lg-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <h4 class="border-bottom pb-3 mb-3"><i class="fas fa-question-circle me-2 text-primary"></i>Nasıl Kullanılır?</h4>
                        <ol class="ps-3">
                            <li class="mb-3">Yukarıdaki sekmelerden bir yükleme metodunu seçin: <span class="fst-italic fw-bold">Bilgisayardan Yükle</span>, <span class="fst-italic fw-bold">İnternetten Yükle</span>, <span class="fst-italic fw-bold">Sürükle & Bırak</span> veya <span class="fst-italic fw-bold">Yapıştır & Yükle</span></li>
                            <li class="mb-3">Fotoğraflarınızı seçin veya belirtilen alana sürükleyin/yapıştırın</li>
                            <li class="mb-3">Yükleme düğmesine tıklayarak işlemi tamamlayın</li>
                            <li class="mb-3">Yükleme tamamlandığında fotoğrafınızın bağlantısını alın veya indirin</li>
                            <li>Fotoğraflarınızı takip etmek için <a href="register.php" class="text-decoration-none">üye olabilir</a> veya <a href="login.php" class="text-decoration-none">giriş yapabilirsiniz</a></li>
                        </ol>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-6 mt-4 mt-lg-0">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <h4 class="border-bottom pb-3 mb-3"><i class="fas fa-cog me-2 text-primary"></i>Özellikler</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <ul class="list-unstyled">
                                    <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>Hızlı Yükleme</li>
                                    <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>Çoklu Format Desteği</li>
                                    <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>5MB'a Kadar Dosya Boyutu</li>
                                    <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>Sürükle & Bırak Özelliği</li>
                                    <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>Panodan Yapıştırma</li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <ul class="list-unstyled">
                                    <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>URL ile Yükleme</li>
                                    <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>Üyelik Sistemi</li>
                                    <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>Fotoğraf Yönetimi</li>
                                    <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>Güvenli ve Hızlı</li>
                                    <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i>SEO Dostu Bağlantılar</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <?php if (!empty($settings['adsense_code'])): ?>
        <!-- Reklam Alanı -->
        <div class="text-center mt-5">
            <?php echo $settings['adsense_code']; ?>
        </div>
        <?php endif; ?>
    </div>

    <!-- Footer -->
    <footer class="bg-dark text-white py-4">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h5><i class="fas fa-camera-retro me-2"></i><?php echo $settings['site_title']; ?></h5>
                    <p><?php echo $settings['site_description']; ?></p>
                </div>
                <div class="col-md-3">
                    <h5>Bağlantılar</h5>
                    <ul class="list-unstyled">
                        <li><a href="index.php" class="text-white"><i class="fas fa-home me-1"></i> Ana Sayfa</a></li>
                        <li><a href="login.php" class="text-white"><i class="fas fa-sign-in-alt me-1"></i> Giriş Yap</a></li>
                        <li><a href="register.php" class="text-white"><i class="fas fa-user-plus me-1"></i> Kayıt Ol</a></li>
                    </ul>
                </div>
                <div class="col-md-3">
                    <h5>İletişim</h5>
                    <ul class="list-unstyled">
                        <?php if (!empty($settings['contact_email'])): ?>
                        <li><i class="fas fa-envelope me-1"></i> <?php echo sanitize($settings['contact_email']); ?></li>
                        <?php endif; ?>
                        
                        <?php if (!empty($settings['contact_phone'])): ?>
                        <li><i class="fas fa-phone me-1"></i> <?php echo sanitize($settings['contact_phone']); ?></li>
                        <?php endif; ?>
                        
                        <?php if (!empty($settings['contact_address'])): ?>
                        <li><i class="fas fa-map-marker-alt me-1"></i> <?php echo sanitize($settings['contact_address']); ?></li>
                        <?php endif; ?>
                        
                        <?php if (!empty($settings['contact_website'])): ?>
                        <li><i class="fas fa-globe me-1"></i> <?php echo sanitize($settings['contact_website']); ?></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
            <hr>
            <div class="text-center">
                <p>&copy; <?php echo date('Y'); ?> <?php echo $settings['site_title']; ?>. Tüm hakları saklıdır.</p>
            </div>
        </div>
    </footer>

    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script src="js/upload.js"></script>
</body>
</html> 