<?php
// Gerekli dosyaları include et
require_once 'inc/autoload.php';

// Kullanıcı giriş kontrolü
if (!checkLogin()) {
    header('Location: login.php');
    exit;
}

// User sınıfını başlat
$user = new User($conn);

// Kullanıcı bilgilerini al
$userId = $_SESSION['user_id'];
$userInfo = getUserInfo($userId, $conn);

// Kullanıcı fotoğraflarını al
$userPhotos = $user->getUserPhotos($userId);

// Site ayarlarını al
$settings = getSiteSettings($conn);

// Sayfa başlığını ayarla
$pageTitle = getPageTitle('Profilim', $conn);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo $settings['site_description']; ?>">
    <meta name="keywords" content="<?php echo $settings['site_keywords']; ?>">
    <title><?php echo $pageTitle; ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/style.css">
    
    <!-- Google Analytics -->
    <?php if (!empty($settings['analytics_code'])): ?>
    <?php echo $settings['analytics_code']; ?>
    <?php endif; ?>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-camera-retro me-2"></i><?php echo $settings['site_title']; ?>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php"><i class="fas fa-home me-1"></i> Ana Sayfa</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="profile.php"><i class="fas fa-user me-1"></i> Profilim</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="logout.php"><i class="fas fa-sign-out-alt me-1"></i> Çıkış Yap</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Profile Section -->
    <div class="container py-5">
        <div class="row">
            <div class="col-md-4">
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h5 class="mb-0 text-primary"><i class="fas fa-user-circle me-2"></i>Profil Bilgileri</h5>
                    </div>
                    <div class="card-body">
                        <div class="text-center mb-3">
                            <i class="fas fa-user-circle fa-5x text-primary"></i>
                        </div>
                        <h4 class="text-center mb-3"><?php echo sanitize($userInfo['username']); ?></h4>
                        <p class="text-center text-muted mb-0"><?php echo sanitize($userInfo['email']); ?></p>
                        <hr>
                        <p class="mb-0"><i class="fas fa-calendar-alt me-2"></i>Üyelik Tarihi: <?php echo date('d.m.Y', strtotime($userInfo['created_at'])); ?></p>
                        <p class="mb-0"><i class="fas fa-images me-2"></i>Toplam Fotoğraf: <?php echo count($userPhotos); ?></p>
                    </div>
                </div>
                
                <?php if (!empty($settings['adsense_code'])): ?>
                <!-- Reklam Alanı -->
                <div class="text-center mb-4">
                    <?php echo $settings['adsense_code']; ?>
                </div>
                <?php endif; ?>
            </div>
            
            <div class="col-md-8">
                <div class="card shadow">
                    <div class="card-header py-3">
                        <h5 class="mb-0 text-primary"><i class="fas fa-images me-2"></i>Yüklediğim Fotoğraflar</h5>
                    </div>
                    <div class="card-body">
                        <?php if (count($userPhotos) > 0): ?>
                            <div class="row g-4">
                                <?php foreach ($userPhotos as $photo): ?>
                                <div class="col-md-6 col-lg-4">
                                    <div class="card photo-card h-100">
                                        <img src="<?php echo $photo['file_url']; ?>" class="card-img-top" alt="<?php echo sanitize($photo['original_name']); ?>">
                                        <div class="card-body">
                                            <h5 class="card-title text-truncate"><?php echo sanitize($photo['original_name']); ?></h5>
                                            <p class="card-text">
                                                <small class="text-muted">
                                                    <i class="fas fa-file me-1"></i> <?php echo strtoupper($photo['file_type']); ?> - 
                                                    <i class="fas fa-weight me-1"></i> <?php echo formatFileSize($photo['file_size']); ?><br>
                                                    <i class="far fa-calendar-alt me-1"></i> <?php echo date('d.m.Y H:i', strtotime($photo['created_at'])); ?>
                                                </small>
                                            </p>
                                        </div>
                                        <div class="card-footer text-center">
                                            <a href="<?php echo $photo['file_url']; ?>" class="btn btn-sm btn-primary" target="_blank">
                                                <i class="fas fa-eye me-1"></i> Görüntüle
                                            </a>
                                            <a href="<?php echo $photo['file_url']; ?>" class="btn btn-sm btn-success" download>
                                                <i class="fas fa-download me-1"></i> İndir
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        <?php else: ?>
                            <div class="text-center p-5">
                                <i class="far fa-images fa-4x text-muted mb-3"></i>
                                <h4 class="text-muted">Henüz hiç fotoğraf yüklemediniz</h4>
                                <p>Ana sayfaya giderek yeni fotoğraflar yükleyebilirsiniz.</p>
                                <a href="index.php" class="btn btn-primary mt-2">
                                    <i class="fas fa-upload me-1"></i> Fotoğraf Yükle
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-dark text-white py-4">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h5><i class="fas fa-camera-retro me-2"></i><?php echo $settings['site_title']; ?></h5>
                    <p><?php echo $settings['site_description']; ?></p>
                </div>
                <div class="col-md-3">
                    <h5>Bağlantılar</h5>
                    <ul class="list-unstyled">
                        <li><a href="index.php" class="text-white"><i class="fas fa-home me-1"></i> Ana Sayfa</a></li>
                        <li><a href="profile.php" class="text-white"><i class="fas fa-user me-1"></i> Profilim</a></li>
                        <li><a href="logout.php" class="text-white"><i class="fas fa-sign-out-alt me-1"></i> Çıkış Yap</a></li>
                    </ul>
                </div>
                <div class="col-md-3">
                    <h5>İletişim</h5>
                    <ul class="list-unstyled">
                        <li><i class="fas fa-envelope me-1"></i> iletisim@example.com</li>
                        <li><i class="fas fa-globe me-1"></i> www.example.com</li>
                    </ul>
                </div>
            </div>
            <hr>
            <div class="text-center">
                <p>&copy; <?php echo date('Y'); ?> <?php echo $settings['site_title']; ?>. Tüm hakları saklıdır.</p>
            </div>
        </div>
    </footer>

    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 