<?php
// Gerekli dosyaları include et
require_once 'inc/autoload.php';

// Photo sınıfını başlat
$photoClass = new Photo($conn);

// Fotoğraf ID kontrolü
if (isset($_GET['id']) && !empty($_GET['id'])) {
    $photoId = (int)$_GET['id'];
    $photo = $photoClass->getPhoto($photoId);
    
    if ($photo) {
        // Güvenli erişim için token oluştur
        $viewUrl = $photoClass->getSecurePhotoUrl($photoId);
        
        // Site URL'sini al
        $siteUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
        
        // Paylaşım URL'leri
        $shareUrl = $siteUrl . '/' . $viewUrl;
        $bbCodeUrl = '[img]' . $shareUrl . '[/img]';
        $htmlUrl = '&lt;img src="' . $shareUrl . '" alt="' . sanitize($photo['original_name']) . '" /&gt;';
        $bbCodeLinkUrl = '[url=' . $shareUrl . '][img]' . $shareUrl . '[/img][/url]';
        $htmlLinkUrl = '<a href="' . $shareUrl . '" target="_blank"><img src="' . $shareUrl . '" alt="' . sanitize($photo['original_name']) . '" style="max-width: 500px;"></a>';
        $markdownUrl = '![' . sanitize($photo['original_name']) . '](' . $shareUrl . ')';
        $markdownLinkUrl = '[![' . sanitize($photo['original_name']) . '](' . $shareUrl . ')](' . $shareUrl . ')';
    } else {
        header('Location: index.php');
        exit;
    }
} else {
    header('Location: index.php');
    exit;
}

// Fotoğraf yoksa ana sayfaya yönlendir
if (!$photo) {
    header("Location: index.php");
    exit;
}

// Sayfa başlığını ayarla
$pageTitle = getPageTitle('Fotoğraf Başarıyla Yüklendi', $conn);

// Site ayarlarını al
$settings = getSiteSettings($conn);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo $settings['site_description']; ?>">
    <meta name="keywords" content="<?php echo $settings['site_keywords']; ?>">
    <title><?php echo $pageTitle; ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/style.css">
    
    <!-- Google Analytics -->
    <?php if (!empty($settings['analytics_code'])): ?>
    <?php echo $settings['analytics_code']; ?>
    <?php endif; ?>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-camera-retro me-2"></i><?php echo $settings['site_title']; ?>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php"><i class="fas fa-home me-1"></i> Ana Sayfa</a>
                    </li>
                    <?php if (checkLogin()): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="profile.php"><i class="fas fa-user me-1"></i> Profilim</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="logout.php"><i class="fas fa-sign-out-alt me-1"></i> Çıkış Yap</a>
                    </li>
                    <?php else: ?>
                    <li class="nav-item">
                        <a class="nav-link" href="login.php"><i class="fas fa-sign-in-alt me-1"></i> Giriş Yap</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="register.php"><i class="fas fa-user-plus me-1"></i> Kayıt Ol</a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Success Container -->
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="card shadow-sm border-0">
                    <div class="card-header bg-success text-white">
                        <h4 class="mb-0"><i class="fas fa-check-circle me-2"></i>Fotoğraf Başarıyla Yüklendi</h4>
                    </div>
                    <div class="card-body">
                        <!-- Resim Önizleme -->
                        <div class="text-center mb-4">
                            <img src="<?php echo $viewUrl; ?>" class="img-fluid rounded" alt="<?php echo sanitize($photo['original_name']); ?>" style="max-height: 300px;">
                        </div>
                        
                        <!-- Bilgi ve İşlemler -->
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h5 class="border-bottom pb-2 mb-3">Dosya Bilgileri</h5>
                                        <ul class="list-unstyled">
                                            <li class="mb-2"><strong><i class="fas fa-file-alt me-2"></i>Orijinal Ad:</strong> <?php echo sanitize($photo['original_name']); ?></li>
                                            <li class="mb-2"><strong><i class="fas fa-file me-2"></i>Dosya Türü:</strong> <?php echo strtoupper($photo['file_type']); ?></li>
                                            <li class="mb-2"><strong><i class="fas fa-weight me-2"></i>Dosya Boyutu:</strong> <?php echo formatFileSize($photo['file_size']); ?></li>
                                            <li class="mb-2"><strong><i class="far fa-calendar-alt me-2"></i>Yükleme Tarihi:</strong> <?php echo date('d.m.Y H:i', strtotime($photo['created_at'])); ?></li>
                                        </ul>
                                    </div>
                                    <div class="col-md-6">
                                        <h5 class="border-bottom pb-2 mb-3">Hızlı İşlemler</h5>
                                        <div class="d-grid gap-2">
                                            <a href="<?php echo $viewUrl; ?>" class="btn btn-primary" target="_blank">
                                                <i class="fas fa-eye me-2"></i>Fotoğrafı Görüntüle
                                            </a>
                                            <a href="<?php echo $viewUrl; ?>" class="btn btn-success" download>
                                                <i class="fas fa-download me-2"></i>Fotoğrafı İndir
                                            </a>
                                            <a href="index.php" class="btn btn-outline-primary">
                                                <i class="fas fa-upload me-2"></i>Yeni Fotoğraf Yükle
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-lg-6 mt-4 mt-lg-0">
                                <div class="card">
                                    <div class="card-header">
                                        <ul class="nav nav-tabs card-header-tabs" id="sharingTabs" role="tablist">
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link active" id="url-tab" data-bs-toggle="tab" data-bs-target="#url" type="button" role="tab" aria-controls="url" aria-selected="true">
                                                    <i class="fas fa-link me-1"></i> URL
                                                </button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link" id="html-tab" data-bs-toggle="tab" data-bs-target="#html" type="button" role="tab" aria-controls="html" aria-selected="false">
                                                    <i class="fas fa-code me-1"></i> HTML
                                                </button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link" id="bbcode-tab" data-bs-toggle="tab" data-bs-target="#bbcode" type="button" role="tab" aria-controls="bbcode" aria-selected="false">
                                                    <i class="fas fa-quote-right me-1"></i> BBCode
                                                </button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link" id="markdown-tab" data-bs-toggle="tab" data-bs-target="#markdown" type="button" role="tab" aria-controls="markdown" aria-selected="false">
                                                    <i class="fab fa-markdown me-1"></i> Markdown
                                                </button>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="card-body">
                                        <div class="tab-content" id="sharingTabsContent">
                                            <!-- URL Sekmesi -->
                                            <div class="tab-pane fade show active" id="url" role="tabpanel" aria-labelledby="url-tab">
                                                <p class="text-muted small">Fotoğrafınızı direkt link olarak paylaşın.</p>
                                                <div class="mb-3">
                                                    <label class="form-label">Direkt Bağlantı:</label>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control" value="<?php echo $shareUrl; ?>" id="directLink" readonly>
                                                        <button class="btn btn-primary" type="button" onclick="copyToClipboard('directLink')">
                                                            <i class="far fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <!-- HTML Sekmesi -->
                                            <div class="tab-pane fade" id="html" role="tabpanel" aria-labelledby="html-tab">
                                                <p class="text-muted small">Website ve bloglar için HTML kodu.</p>
                                                <div class="mb-3">
                                                    <label class="form-label">Tam Boyut Resim:</label>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control" value="<?php echo $htmlUrl; ?>" id="htmlFull" readonly>
                                                        <button class="btn btn-primary" type="button" onclick="copyToClipboard('htmlFull')">
                                                            <i class="far fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">Resme Link:</label>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control" value="<?php echo $htmlLinkUrl; ?>" id="htmlLink" readonly>
                                                        <button class="btn btn-primary" type="button" onclick="copyToClipboard('htmlLink')">
                                                            <i class="far fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <!-- BBCode Sekmesi -->
                                            <div class="tab-pane fade" id="bbcode" role="tabpanel" aria-labelledby="bbcode-tab">
                                                <p class="text-muted small">Forumlar için BBCode.</p>
                                                <div class="mb-3">
                                                    <label class="form-label">Tam Boyut Resim:</label>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control" value="<?php echo $bbCodeUrl; ?>" id="bbcodeFull" readonly>
                                                        <button class="btn btn-primary" type="button" onclick="copyToClipboard('bbcodeFull')">
                                                            <i class="far fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">Resme Link:</label>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control" value="<?php echo $bbCodeLinkUrl; ?>" id="bbcodeLink" readonly>
                                                        <button class="btn btn-primary" type="button" onclick="copyToClipboard('bbcodeLink')">
                                                            <i class="far fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <!-- Markdown Sekmesi -->
                                            <div class="tab-pane fade" id="markdown" role="tabpanel" aria-labelledby="markdown-tab">
                                                <p class="text-muted small">GitHub ve Markdown destekleyen siteler için.</p>
                                                <div class="mb-3">
                                                    <label class="form-label">Tam Boyut Resim:</label>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control" value="<?php echo $markdownUrl; ?>" id="markdownFull" readonly>
                                                        <button class="btn btn-primary" type="button" onclick="copyToClipboard('markdownFull')">
                                                            <i class="far fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">Resme Link:</label>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control" value="<?php echo $markdownLinkUrl; ?>" id="markdownLink" readonly>
                                                        <button class="btn btn-primary" type="button" onclick="copyToClipboard('markdownLink')">
                                                            <i class="far fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-dark text-white py-4">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h5><i class="fas fa-camera-retro me-2"></i><?php echo $settings['site_title']; ?></h5>
                    <p><?php echo $settings['site_description']; ?></p>
                </div>
                <div class="col-md-3">
                    <h5>Bağlantılar</h5>
                    <ul class="list-unstyled">
                        <li><a href="index.php" class="text-white"><i class="fas fa-home me-1"></i> Ana Sayfa</a></li>
                        <li><a href="login.php" class="text-white"><i class="fas fa-sign-in-alt me-1"></i> Giriş Yap</a></li>
                        <li><a href="register.php" class="text-white"><i class="fas fa-user-plus me-1"></i> Kayıt Ol</a></li>
                    </ul>
                </div>
                <div class="col-md-3">
                    <h5>İletişim</h5>
                    <ul class="list-unstyled">
                        <?php if (!empty($settings['contact_email'])): ?>
                        <li><i class="fas fa-envelope me-1"></i> <?php echo sanitize($settings['contact_email']); ?></li>
                        <?php endif; ?>
                        
                        <?php if (!empty($settings['contact_phone'])): ?>
                        <li><i class="fas fa-phone me-1"></i> <?php echo sanitize($settings['contact_phone']); ?></li>
                        <?php endif; ?>
                        
                        <?php if (!empty($settings['contact_address'])): ?>
                        <li><i class="fas fa-map-marker-alt me-1"></i> <?php echo sanitize($settings['contact_address']); ?></li>
                        <?php endif; ?>
                        
                        <?php if (!empty($settings['contact_website'])): ?>
                        <li><i class="fas fa-globe me-1"></i> <?php echo sanitize($settings['contact_website']); ?></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
            <hr>
            <div class="text-center">
                <p>&copy; <?php echo date('Y'); ?> <?php echo $settings['site_title']; ?>. Tüm hakları saklıdır.</p>
            </div>
        </div>
    </footer>

    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Copy to Clipboard Script -->
    <script>
        function copyToClipboard(elementId) {
            const copyText = document.getElementById(elementId);
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            document.execCommand("copy");
            
            // Başarılı mesajı
            const button = copyText.nextElementSibling;
            const originalIcon = button.innerHTML;
            button.innerHTML = '<i class="fas fa-check"></i>';
            button.classList.remove('btn-primary');
            button.classList.add('btn-success');
            
            setTimeout(function() {
                button.innerHTML = originalIcon;
                button.classList.remove('btn-success');
                button.classList.add('btn-primary');
            }, 2000);
        }
    </script>
</body>
</html> 