<?php
// Gerekli dosyaları include et
require_once 'inc/autoload.php';

// JSON formatında yanıt döneceğiz
header('Content-Type: application/json');

// Fotoğraf sınıfını başlat
$photo = new Photo($conn);

// Kullanıcı giriş kontrolü
$userId = (isset($_SESSION['user_id'])) ? $_SESSION['user_id'] : null;

// Dosyadan yükleme
if (isset($_FILES['file']) && !empty($_FILES['file']['name'])) {
    $result = $photo->uploadFromFile($_FILES['file'], $userId);
    echo json_encode($result);
    exit;
}

// URL'den yükleme 
if (isset($_POST['url']) && !empty($_POST['url'])) {
    $result = $photo->uploadFromUrl($_POST['url'], $userId);
    echo json_encode($result);
    exit;
}

// Base64'ten yükleme
if (isset($_POST['data']) && !empty($_POST['data'])) {
    $result = $photo->uploadFromData($_POST['data'], $userId);
    echo json_encode($result);
    exit;
}

// Hiçbir yükleme yapılmadıysa hata döndür
echo json_encode([
    'success' => false,
    'message' => 'Hiçbir fotoğraf yüklenmedi.'
]);
?> 