<?php
// Gerekli dosyaları include et
require_once 'inc/autoload.php';

// Fotoğraf ID ve token kontrolü
$photoId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$token = isset($_GET['token']) ? $_GET['token'] : '';

if ($photoId <= 0 || empty($token)) {
    header("HTTP/1.0 403 Forbidden");
    die("Erişim engellendi.");
}

// Photo sınıfını başlat
$photoClass = new Photo($conn);

// Fotoğrafı token kontrolü ile getir
$photo = $photoClass->getPhoto($photoId, $token);

if (!$photo) {
    header("HTTP/1.0 404 Not Found");
    die("Fotoğraf bulunamadı veya erişim izniniz yok.");
}

// Dosya yolunu oluştur
$filePath = __DIR__ . '/' . $photo['file_url'];

// Dosya var mı kontrol et
if (!file_exists($filePath)) {
    header("HTTP/1.0 404 Not Found");
    die("Fotoğraf dosyası bulunamadı.");
}

// MIME türünü belirle
$finfo = new finfo(FILEINFO_MIME_TYPE);
$mime = $finfo->file($filePath);

// İzin verilen MIME türleri
$allowedMimes = [
    'image/jpeg',
    'image/png',
    'image/gif'
];

// Güvenlik kontrolü
if (!in_array($mime, $allowedMimes)) {
    header("HTTP/1.0 403 Forbidden");
    die("Geçersiz dosya türü.");
}

// Önbellek kontrolü (1 gün)
$cacheTime = 86400; // 1 gün
header("Cache-Control: max-age=$cacheTime, public");
header("Expires: " . gmdate('D, d M Y H:i:s', time() + $cacheTime) . ' GMT');
header("Last-Modified: " . gmdate('D, d M Y H:i:s', filemtime($filePath)) . ' GMT');

// Content-Type ve dosya boyutu bilgilerini gönder
header("Content-Type: $mime");
header("Content-Length: " . filesize($filePath));
header("Content-Disposition: inline; filename=\"" . basename($photo['original_name']) . "\"");

// Güvenlik başlıkları
header("X-Content-Type-Options: nosniff");
header("X-Frame-Options: SAMEORIGIN");
header("Content-Security-Policy: default-src 'self'");

// Buffer temizle
ob_clean();
flush();

// Dosyayı oku ve gönder
readfile($filePath);
exit; 