<?php
/**
 * MetinPaylaş - Admin Dashboard
 */

// Gerekli dosyaları dahil et
require_once '../includes/config.php';
require_once '../includes/functions.php';

// Admin girişi kontrolü
if (!isset($_SESSION['admin_giris']) || $_SESSION['admin_giris'] !== true) {
    header('Location: index.php');
    exit;
}

// Ayarları getir
$ayarlar = ayarlariGetir();
$varsayilan_tema = isset($ayarlar['tema']) ? $ayarlar['tema'] : 'light';

// İstatistikleri getir
$db = baglan();

// Toplam paylaşım sayısı
$toplam_paylasim = $db->query("SELECT COUNT(*) as toplam FROM paylasimlar")->fetch()['toplam'];

// Bugünkü paylaşımlar
$bugunki_paylasim = $db->query("SELECT COUNT(*) as toplam FROM paylasimlar WHERE DATE(tarih) = CURDATE()")->fetch()['toplam'];

// Toplam görüntülenme
$toplam_goruntulenme = $db->query("SELECT SUM(goruntulenme) as toplam FROM paylasimlar")->fetch()['toplam'] ?? 0;

// Toplam kullanıcı sayısı
$toplam_kullanici = $db->query("SELECT COUNT(*) as toplam FROM kullanicilar WHERE durum = 1")->fetch()['toplam'];

// Şifre korumalı paylaşımlar
$sifreli_paylasim = $db->query("SELECT COUNT(*) as toplam FROM paylasimlar WHERE sifre IS NOT NULL")->fetch()['toplam'];

// Son paylaşımlar (5 adet)
$son_paylasimlar = $db->query("SELECT id, baslik, metin, tarih, goruntulenme, ip_adresi FROM paylasimlar ORDER BY tarih DESC LIMIT 5")->fetchAll();

// Popüler paylaşımlar (en çok görüntülenen)
$populer_paylasimlar = $db->query("SELECT id, baslik, metin, tarih, goruntulenme FROM paylasimlar ORDER BY goruntulenme DESC LIMIT 5")->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - <?php echo SITE_TITLE; ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <link rel="stylesheet" href="assets/css/admin.css">

    <style>
        /* Dashboard'a özel ek stiller */
        .avatar {
            width: 40px;
            height: 40px;
            background: var(--primary-color);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
        }
    </style>
</head>
<body data-bs-theme="<?php echo $varsayilan_tema; ?>">
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <h5 class="mb-0">
                <i class="bi bi-shield-lock text-primary me-2"></i>
                Admin Panel
            </h5>
            <small class="text-muted">MetinPaylaş</small>
        </div>
        
        <nav class="sidebar-nav">
            <a href="dashboard.php" class="nav-link active">
                <i class="bi bi-speedometer2"></i>
                Dashboard
            </a>
            <a href="paylasimlar.php" class="nav-link">
                <i class="bi bi-file-text"></i>
                Paylaşımlar
            </a>
            <a href="kullanicilar.php" class="nav-link">
                <i class="bi bi-people"></i>
                Kullanıcılar
            </a>
            <a href="ayarlar.php" class="nav-link">
                <i class="bi bi-gear"></i>
                Site Ayarları
            </a>
            <a href="istatistikler.php" class="nav-link">
                <i class="bi bi-bar-chart"></i>
                İstatistikler
            </a>
            <a href="guvenlik.php" class="nav-link">
                <i class="bi bi-shield-check"></i>
                Güvenlik
            </a>
            <hr class="my-3">
            <a href="../index.php" class="nav-link" target="_blank">
                <i class="bi bi-box-arrow-up-right"></i>
                Siteyi Görüntüle
            </a>
            <a href="cikis.php" class="nav-link text-danger">
                <i class="bi bi-box-arrow-right"></i>
                Çıkış Yap
            </a>
        </nav>
    </div>
    
    <!-- Ana İçerik -->
    <div class="main-content">
        <!-- Üst Bar -->
        <div class="top-bar">
            <div>
                <h4 class="mb-0">Dashboard</h4>
                <small class="text-muted">Hoş geldiniz, <?php echo htmlspecialchars($_SESSION['admin_ad_soyad'] ?? $_SESSION['admin_kullanici_adi']); ?></small>
            </div>
            <div>
                <button class="btn btn-outline-secondary btn-sm me-2" id="temaDegistir" title="Tema Değiştir">
                    <i class="bi bi-sun"></i>
                </button>
                <span class="badge bg-primary"><?php echo $_SESSION['admin_yetki']; ?></span>
            </div>
        </div>
        
        <!-- İstatistik Kartları -->
        <div class="row mb-4">
            <div class="col-md-2">
                <div class="stat-card">
                    <div class="d-flex align-items-center">
                        <div class="stat-icon bg-primary">
                            <i class="bi bi-file-text"></i>
                        </div>
                        <div class="ms-3">
                            <p class="stat-number"><?php echo number_format($toplam_paylasim); ?></p>
                            <p class="stat-label">Toplam Paylaşım</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-2">
                <div class="stat-card">
                    <div class="d-flex align-items-center">
                        <div class="stat-icon bg-success">
                            <i class="bi bi-calendar-day"></i>
                        </div>
                        <div class="ms-3">
                            <p class="stat-number"><?php echo number_format($bugunki_paylasim); ?></p>
                            <p class="stat-label">Bugünkü Paylaşım</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-2">
                <div class="stat-card">
                    <div class="d-flex align-items-center">
                        <div class="stat-icon bg-info">
                            <i class="bi bi-eye"></i>
                        </div>
                        <div class="ms-3">
                            <p class="stat-number"><?php echo number_format($toplam_goruntulenme); ?></p>
                            <p class="stat-label">Toplam Görüntülenme</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-2">
                <div class="stat-card">
                    <div class="d-flex align-items-center">
                        <div class="stat-icon bg-warning">
                            <i class="bi bi-people"></i>
                        </div>
                        <div class="ms-3">
                            <p class="stat-number"><?php echo number_format($toplam_kullanici); ?></p>
                            <p class="stat-label">Kullanıcı</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-2">
                <div class="stat-card">
                    <div class="d-flex align-items-center">
                        <div class="stat-icon bg-danger">
                            <i class="bi bi-shield-lock"></i>
                        </div>
                        <div class="ms-3">
                            <p class="stat-number"><?php echo number_format($sifreli_paylasim); ?></p>
                            <p class="stat-label">Şifreli Paylaşım</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- İçerik Alanları -->
        <div class="row">
            <!-- Son Paylaşımlar -->
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="bi bi-clock me-2"></i>Son Paylaşımlar
                        </h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead>
                                    <tr>
                                        <th>Başlık</th>
                                        <th>Tarih</th>
                                        <th>Görüntülenme</th>
                                        <th>İşlem</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($son_paylasimlar as $paylasim): ?>
                                        <tr>
                                            <td>
                                                <div>
                                                    <strong><?php echo htmlspecialchars($paylasim['baslik'] ?: 'Başlıksız'); ?></strong>
                                                    <br>
                                                    <small class="text-muted">
                                                        <?php echo htmlspecialchars(substr(strip_tags($paylasim['metin']), 0, 50)) . '...'; ?>
                                                    </small>
                                                </div>
                                            </td>
                                            <td>
                                                <small><?php echo date('d.m.Y H:i', strtotime($paylasim['tarih'])); ?></small>
                                            </td>
                                            <td>
                                                <span class="badge bg-primary"><?php echo $paylasim['goruntulenme']; ?></span>
                                            </td>
                                            <td>
                                                <a href="../goster.php?id=<?php echo $paylasim['id']; ?>" class="btn btn-sm btn-outline-primary" target="_blank">
                                                    <i class="bi bi-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Popüler Paylaşımlar -->
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="bi bi-fire me-2"></i>Popüler Paylaşımlar
                        </h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead>
                                    <tr>
                                        <th>Başlık</th>
                                        <th>Tarih</th>
                                        <th>Görüntülenme</th>
                                        <th>İşlem</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($populer_paylasimlar as $paylasim): ?>
                                        <tr>
                                            <td>
                                                <div>
                                                    <strong><?php echo htmlspecialchars($paylasim['baslik'] ?: 'Başlıksız'); ?></strong>
                                                    <br>
                                                    <small class="text-muted">
                                                        <?php echo htmlspecialchars(substr(strip_tags($paylasim['metin']), 0, 50)) . '...'; ?>
                                                    </small>
                                                </div>
                                            </td>
                                            <td>
                                                <small><?php echo date('d.m.Y H:i', strtotime($paylasim['tarih'])); ?></small>
                                            </td>
                                            <td>
                                                <span class="badge bg-success"><?php echo $paylasim['goruntulenme']; ?></span>
                                            </td>
                                            <td>
                                                <a href="../goster.php?id=<?php echo $paylasim['id']; ?>" class="btn btn-sm btn-outline-primary" target="_blank">
                                                    <i class="bi bi-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Admin Tema Değiştirme -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const themeToggle = document.getElementById('temaDegistir');
            if (!themeToggle) return;
            
            // Mevcut temayı al
            let currentTheme = document.body.getAttribute('data-bs-theme') || 'light';
            updateThemeIcon(currentTheme);
            
            // Tema değiştirme
            themeToggle.addEventListener('click', function() {
                const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
                
                // Görsel değişiklik
                document.body.setAttribute('data-bs-theme', newTheme);
                document.documentElement.setAttribute('data-bs-theme', newTheme);
                localStorage.setItem('theme', newTheme);
                updateThemeIcon(newTheme);
                currentTheme = newTheme;
                
                // Animasyon
                document.body.classList.add('theme-transition');
                setTimeout(() => {
                    document.body.classList.remove('theme-transition');
                }, 300);
                
                // Veritabanında güncelle
                updateThemeInDatabase(newTheme);
            });
            
            function updateThemeIcon(theme) {
                const icon = themeToggle.querySelector('i');
                if (icon) {
                    icon.className = theme === 'dark' ? 'bi bi-sun' : 'bi bi-moon';
                }
            }
            
            function updateThemeInDatabase(theme) {
                fetch('tema-degistir.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ tema: theme })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.basarili) {
                        console.log('Tema veritabanında güncellendi:', theme);
                    } else {
                        console.error('Tema güncellenirken hata:', data.mesaj);
                    }
                })
                .catch(error => {
                    console.error('Tema güncelleme hatası:', error);
                });
            }
        });
    </script>
</body>
</html>
