<?php
/**
 * MetinPaylaş - Admin Panel Giriş Sayfası
 */

// Gerekli dosyaları dahil et
require_once '../includes/config.php';
require_once '../includes/functions.php';

// Ayarları getir
$ayarlar = ayarlariGetir();
$varsayilan_tema = isset($ayarlar['tema']) ? $ayarlar['tema'] : 'light';

// Zaten giriş yapmışsa dashboard'a yönlendir
if (isset($_SESSION['admin_giris']) && $_SESSION['admin_giris'] === true) {
    header('Location: dashboard.php');
    exit;
}

$hata_mesaji = '';

// Giriş formu gönderildi mi?
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['admin_giris'])) {
    $kullanici_adi = trim($_POST['kullanici_adi'] ?? '');
    $sifre = $_POST['sifre'] ?? '';
    
    if (empty($kullanici_adi) || empty($sifre)) {
        $hata_mesaji = 'Kullanıcı adı ve şifre gereklidir.';
    } else {
        // Kullanıcıyı doğrula
        $db = baglan();
        $sorgu = $db->prepare("SELECT id, kullanici_adi, sifre, ad_soyad, yetki FROM kullanicilar WHERE kullanici_adi = ? AND durum = 1 AND yetki IN ('admin', 'moderator')");
        $sorgu->execute([$kullanici_adi]);
        
        if ($sorgu->rowCount() > 0) {
            $kullanici = $sorgu->fetch();
            
            if (password_verify($sifre, $kullanici['sifre'])) {
                // Giriş başarılı
                $_SESSION['admin_giris'] = true;
                $_SESSION['admin_id'] = $kullanici['id'];
                $_SESSION['admin_kullanici_adi'] = $kullanici['kullanici_adi'];
                $_SESSION['admin_ad_soyad'] = $kullanici['ad_soyad'];
                $_SESSION['admin_yetki'] = $kullanici['yetki'];
                
                // Son giriş tarihini ve IP'yi güncelle
                $guncelle = $db->prepare("UPDATE kullanicilar SET son_giris = NOW(), son_giris_ip = ? WHERE id = ?");
                $guncelle->execute([$_SERVER['REMOTE_ADDR'], $kullanici['id']]);
                
                header('Location: dashboard.php');
                exit;
            } else {
                $hata_mesaji = 'Kullanıcı adı veya şifre hatalı.';
            }
        } else {
            $hata_mesaji = 'Kullanıcı adı veya şifre hatalı.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - <?php echo SITE_TITLE; ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Admin CSS -->
    <link rel="stylesheet" href="assets/css/admin.css">
    
    <style>
        :root {
            --primary-color: #6366f1;
            --primary-hover: #4f46e5;
            --bg-main: #f8fafc;
            --bg-card: #ffffff;
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --border-color: #e2e8f0;
            --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        }
        
        [data-bs-theme="dark"] {
            --bg-main: #0f172a;
            --bg-card: #1e293b;
            --text-primary: #f1f5f9;
            --text-secondary: #94a3b8;
            --border-color: #334155;
            --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.3);
        }
        
        body {
            background: linear-gradient(135deg, var(--primary-color), #8b5cf6);
            min-height: 100vh;
            font-family: 'Inter', sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .login-container {
            background: var(--bg-card);
            border-radius: 1rem;
            box-shadow: var(--shadow);
            padding: 2.5rem;
            width: 100%;
            max-width: 400px;
            border: 1px solid var(--border-color);
        }
        
        .login-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .login-header h1 {
            color: var(--text-primary);
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .login-header p {
            color: var(--text-secondary);
            margin: 0;
        }
        
        .form-control {
            background-color: var(--bg-main);
            border-color: var(--border-color);
            color: var(--text-primary);
            padding: 0.75rem 1rem;
        }
        
        .form-control:focus {
            background-color: var(--bg-main);
            border-color: var(--primary-color);
            color: var(--text-primary);
            box-shadow: 0 0 0 0.2rem rgba(99, 102, 241, 0.25);
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            padding: 0.75rem;
            font-weight: 600;
        }
        
        .btn-primary:hover {
            background-color: var(--primary-hover);
            border-color: var(--primary-hover);
        }
        
        .alert {
            border: none;
            border-radius: 0.5rem;
        }
        
        .theme-toggle {
            position: absolute;
            top: 1rem;
            right: 1rem;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            color: white;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .theme-toggle:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: scale(1.1);
        }
    </style>
</head>
<body data-bs-theme="<?php echo $varsayilan_tema; ?>">
    <!-- Tema Değiştirme Butonu -->
    <button class="theme-toggle" id="temaDegistir" title="Tema Değiştir">
        <i class="bi bi-sun"></i>
    </button>
    
    <div class="login-container">
        <div class="login-header">
            <h1><i class="bi bi-shield-lock text-primary me-2"></i>Admin Panel</h1>
            <p>MetinPaylaş Yönetim Paneli</p>
        </div>
        
        <?php if (!empty($hata_mesaji)): ?>
            <div class="alert alert-danger" role="alert">
                <i class="bi bi-exclamation-triangle me-2"></i>
                <?php echo htmlspecialchars($hata_mesaji); ?>
            </div>
        <?php endif; ?>
        
        <form method="post" action="">
            <input type="hidden" name="admin_giris" value="1">
            
            <div class="mb-3">
                <label for="kullanici_adi" class="form-label">Kullanıcı Adı</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="bi bi-person"></i></span>
                    <input type="text" class="form-control" id="kullanici_adi" name="kullanici_adi" 
                           value="<?php echo htmlspecialchars($_POST['kullanici_adi'] ?? ''); ?>" 
                           required autocomplete="username">
                </div>
            </div>
            
            <div class="mb-4">
                <label for="sifre" class="form-label">Şifre</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="bi bi-key"></i></span>
                    <input type="password" class="form-control" id="sifre" name="sifre" 
                           required autocomplete="current-password">
                </div>
            </div>
            
            <div class="d-grid">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-box-arrow-in-right me-2"></i>Giriş Yap
                </button>
            </div>
        </form>
        
        <div class="text-center mt-4">
            <a href="../index.php" class="text-decoration-none">
                <i class="bi bi-arrow-left me-1"></i>Ana Sayfaya Dön
            </a>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Tema Değiştirme -->
    <script>
        // Admin giriş sayfası için basit tema değiştirme
        document.addEventListener('DOMContentLoaded', function() {
            const themeToggle = document.getElementById('temaDegistir');
            if (!themeToggle) return;
            
            // Mevcut temayı al
            const currentTheme = document.body.getAttribute('data-bs-theme') || 'light';
            updateThemeIcon(currentTheme);
            
            // Tema değiştirme
            themeToggle.addEventListener('click', function() {
                const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
                document.body.setAttribute('data-bs-theme', newTheme);
                document.documentElement.setAttribute('data-bs-theme', newTheme);
                localStorage.setItem('theme', newTheme);
                updateThemeIcon(newTheme);
                
                // Animasyon
                document.body.classList.add('theme-transition');
                setTimeout(() => {
                    document.body.classList.remove('theme-transition');
                }, 300);
            });
            
            function updateThemeIcon(theme) {
                const icon = themeToggle.querySelector('i');
                if (icon) {
                    icon.className = theme === 'dark' ? 'bi bi-sun' : 'bi bi-moon';
                }
            }
        });
    </script>
</body>
</html>
