<?php
/**
 * MetinPaylaş - Admin Tema Değiştir AJAX Endpoint
 */

// Gerekli dosyaları dahil et
require_once '../includes/config.php';
require_once '../includes/functions.php';

// Admin girişi kontrolü
if (!isset($_SESSION['admin_giris']) || $_SESSION['admin_giris'] !== true) {
    http_response_code(401);
    echo json_encode(['basarili' => false, 'mesaj' => 'Yetkisiz erişim.']);
    exit;
}

// Sadece POST isteklerini kabul et
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['basarili' => false, 'mesaj' => 'Sadece POST istekleri kabul edilir.']);
    exit;
}

// Content-Type başlığını ayarla
header('Content-Type: application/json');

try {
    // Tema değerini al
    $input = json_decode(file_get_contents('php://input'), true);
    $yeni_tema = isset($input['tema']) ? $input['tema'] : '';
    
    // Tema değerini doğrula
    if (!in_array($yeni_tema, ['light', 'dark'])) {
        echo json_encode(['basarili' => false, 'mesaj' => 'Geçersiz tema değeri.']);
        exit;
    }
    
    // Temayı veritabanında güncelle
    $sonuc = ayarGuncelle('tema', $yeni_tema);
    
    if ($sonuc) {
        echo json_encode([
            'basarili' => true, 
            'mesaj' => 'Tema başarıyla güncellendi.',
            'tema' => $yeni_tema
        ]);
    } else {
        echo json_encode(['basarili' => false, 'mesaj' => 'Tema güncellenirken bir hata oluştu.']);
    }
    
} catch (Exception $e) {
    error_log("Admin tema değiştirme hatası: " . $e->getMessage());
    echo json_encode(['basarili' => false, 'mesaj' => 'Sunucu hatası oluştu.']);
}
?>

