// SimpleMDE Markdown Editor için basitleştirilmiş bir sürüm
// SimpleMDE yerine doğrudan Bootstrap ve özel bir çözüm kullanacağız

class SimpleMDE {
    constructor(options) {
        this.element = options.element;
        this.value = this.element.value || '';
        this.placeholder = options.placeholder || '';
        this.status = options.status || [];
        this.toolbar = options.toolbar || [];
        this.autosave = options.autosave || { enabled: false };
        this.spellChecker = options.spellChecker || false;
        
        // Otomatik kayıt
        if (this.autosave && this.autosave.enabled) {
            const savedValue = localStorage.getItem(this.autosave.uniqueId);
            if (savedValue) {
                this.element.value = savedValue;
                this.value = savedValue;
            }
        }
        
        // CodeMirror taklit edici
        this.codemirror = {
            getValue: () => this.element.value,
            setValue: (value) => {
                this.element.value = value;
                this.value = value;
            },
            on: (event, callback) => {
                if (event === 'change') {
                    this.element.addEventListener('input', () => {
                        this.value = this.element.value;
                        if (this.autosave && this.autosave.enabled) {
                            localStorage.setItem(this.autosave.uniqueId, this.value);
                        }
                        callback();
                    });
                }
            }
        };
        
        // Markdown dönüştürücü
        this.markdown = (text) => {
            // Basit markdown dönüşümleri
            let html = text || '';
            
            // Başlıklar
            html = html.replace(/^# (.*?)$/gm, '<h1>$1</h1>');
            html = html.replace(/^## (.*?)$/gm, '<h2>$1</h2>');
            html = html.replace(/^### (.*?)$/gm, '<h3>$1</h3>');
            
            // Kalın, italik ve üstü çizili
            html = html.replace(/\*\*(.*?)\*\*/g, '<strong>$1</strong>');
            html = html.replace(/\*(.*?)\*/g, '<em>$1</em>');
            html = html.replace(/~~(.*?)~~/g, '<del>$1</del>');
            
            // Kod
            html = html.replace(/`(.*?)`/g, '<code>$1</code>');
            
            // Linkler
            html = html.replace(/\[(.*?)\]\((.*?)\)/g, '<a href="$2" target="_blank">$1</a>');
            
            // Listeler
            html = html.replace(/^\* (.*?)$/gm, '<li>$1</li>');
            html = html.replace(/^- (.*?)$/gm, '<li>$1</li>');
            html = html.replace(/^([0-9]+)\. (.*?)$/gm, '<li>$2</li>');
            
            // Satır sonları
            html = html.replace(/\n/g, '<br>');
            
            return html;
        };
        
        // Başlangıçta textarea'yı güncelle
        this.element.value = this.value;
        this.element.placeholder = this.placeholder;
        
        // Basit arayüz
        this.element.classList.add('simplemde-editor');
        
        return this;
    }
}

// SimpleMDE sınıfını global olarak tanımla
window.SimpleMDE = SimpleMDE;

