<?php
/**
 * MetinPaylaş - Veritabanı Yapılandırma Dosyası
 * 
 * Bu dosya veritabanı bağlantısı ve genel ayarlar için kullanılır
 */

// Hata raporlama ayarları (geliştirme ortamında açık, canlıda kapalı olmalı)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Veritabanı bağlantı bilgileri
define('DB_HOST', 'localhost');
define('DB_NAME', 'metinpaylas');
define('DB_USER', 'root'); // Kendi veritabanı kullanıcı adınızı girin
define('DB_PASS', '');     // Kendi veritabanı şifrenizi girin

// Site URL ve başlık ayarları
define('SITE_URL', 'http://localhost/just');
define('SITE_TITLE', 'MetinPaylaş');
define('SITE_DESCRIPTION', 'Hızlı ve kolay metin paylaşım platformu');

// Oturum başlat
session_start();

/**
 * Veritabanı bağlantısını oluşturur
 * 
 * @return PDO Veritabanı bağlantı nesnesi
 */
function baglan() {
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ];
        
        return new PDO($dsn, DB_USER, DB_PASS, $options);
    } catch (PDOException $e) {
        // Hata durumunda kullanıcı dostu mesaj göster
        die("Veritabanına bağlanırken bir hata oluştu: " . $e->getMessage());
    }
}

/**
 * Güvenli metin çıktısı için HTML karakterlerini dönüştürür
 * 
 * @param string $text Dönüştürülecek metin
 * @return string Güvenli hale getirilmiş metin
 */
function guvenli($text) {
    return htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
}

/**
 * Rastgele benzersiz ID oluşturur
 * 
 * @param int $uzunluk ID uzunluğu
 * @return string Oluşturulan ID
 */
function benzersizID($uzunluk = 6) {
    $karakterler = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $id = '';
    
    for ($i = 0; $i < $uzunluk; $i++) {
        $id .= $karakterler[rand(0, strlen($karakterler) - 1)];
    }
    
    return $id;
}

/**
 * Kullanıcının IP adresini alır
 * 
 * @return string IP adresi
 */
function kullaniciIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

/**
 * Tarih formatını Türkçe olarak düzenler
 * 
 * @param string $tarih MySQL tarih formatı
 * @return string Türkçe formatlanmış tarih
 */
function tarihFormati($tarih) {
    $zaman = strtotime($tarih);
    return date('d.m.Y H:i', $zaman);
}
?>

