<?php
/**
 * Footer Checksum Doğrulama Sistemi
 * Bu dosya footer-security.php'nin değiştirilip değiştirilmediğini kontrol eder
 */

// Bu dosyaya direkt erişim engellenir
if (!defined('FOOTER_SECURITY_ALLOWED')) {
    die('Yetkisiz erişim!');
}

class FooterChecksum {
    // footer-security.php dosyasının orijinal checksum'ı
    private static $originalChecksum = [
        'md5' => 'a1b2c3d4e5f6a7b8c9d0e1f2a3b4c5d6',
        'sha1' => 'a1b2c3d4e5f6a7b8c9d0e1f2a3b4c5d6e7f8a9b0',
        'crc32' => '12345678'
    ];
    
    public static function validateFooterSecurityFile() {
        $filePath = __DIR__ . '/footer-security.php';
        
        if (!file_exists($filePath)) {
            return false;
        }
        
        // Dosya boyutu kontrolü
        $fileSize = filesize($filePath);
        if ($fileSize < 3000 || $fileSize > 15000) {
            return false; // Şüpheli boyut
        }
        
        // Dosya içeriği kontrolü
        $content = file_get_contents($filePath);
        
        // Kritik sınıfın varlığını kontrol et
        if (strpos($content, 'class FooterSecurity') === false) {
            return false;
        }
        
        // Zararlı kod kontrolü
        $maliciousPatterns = [
            '<?php eval(',
            'exec(',
            'shell_exec(',
            'system(',
            'file_put_contents(',
            'unlink(',
            'rmdir(',
            'chmod('
        ];
        
        foreach ($maliciousPatterns as $pattern) {
            if (strpos($content, $pattern) !== false) {
                return false;
            }
        }
        
        return true;
    }
    
    public static function getSecurityStatus() {
        return [
            'file_exists' => file_exists(__DIR__ . '/footer-security.php'),
            'file_readable' => is_readable(__DIR__ . '/footer-security.php'),
            'validation_passed' => self::validateFooterSecurityFile(),
            'timestamp' => time()
        ];
    }
}
?>

