<?php
/**
 * Footer Güvenlik Sistemi
 * Bu dosya değiştirilmemeli ve silinmemeli!
 */

class FooterSecurity {
    // Çoklu şifreleme katmanları
    private static $footerKey = 'MTY4NzM0NTI5MQ=='; // Şifreli anahtar
    private static $footerData = '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';
    private static $expectedHash = '2c3cf4bd69f4008913872833d2621539e4970313dbb618edb9aaab4701a06d5d';
    
    // Bu dosyanın orijinal hash'i - değişiklik tespiti için
    private static $fileHash = '7f8a9b2c3d4e5f6a7b8c9d0e1f2a3b4c5d6e7f8a9b0c1d2e3f4a5b6c7d8e9f0a1b';
    
    // Çoklu doğrulama anahtarları
    private static $validationKeys = [
        'primary' => 'Q3Vyc29yLUFJLUZvb3Rlci1TZWN1cml0eQ==',
        'secondary' => 'TWV0aW5QYXlsYXMtUHJvdGVjdGVk',
        'tertiary' => 'Rm9vdGVyLUd1dmVubGlrLVNpc3RlbWk='
    ];
    
    public static function renderFooter() {
        // 0. Çapraz doğrulama sistemi
        if (!self::crossValidation()) {
            return self::getEmergencyFooter();
        }
        
        // 1. Çoklu güvenlik kontrolü
        if (!self::validateSecurity()) {
            return self::getEmergencyFooter();
        }
        
        // 2. Dosya değişiklik tespiti
        if (!self::checkFileModification()) {
            return self::getEmergencyFooter();
        }
        
        // 3. Çoklu anahtar doğrulama
        if (!self::validateMultipleKeys()) {
            return self::getEmergencyFooter();
        }
        
        // 4. Hash kontrolü
        $currentHash = hash('sha256', self::$footerData);
        if ($currentHash !== self::$expectedHash) {
            return self::getEmergencyFooter();
        }
        
        // 5. Dosya bütünlük kontrolü
        if (!self::checkFileIntegrity()) {
            return self::getEmergencyFooter();
        }
        
        // 6. Runtime güvenlik kontrolü
        if (!self::runtimeSecurityCheck()) {
            return self::getEmergencyFooter();
        }
        
        return base64_decode(self::$footerData);
    }
    
    private static function crossValidation() {
        // Çapraz doğrulama - checksum dosyası ile kontrol
        if (file_exists(__DIR__ . '/footer-checksum.php')) {
            require_once __DIR__ . '/footer-checksum.php';
            if (class_exists('FooterChecksum')) {
                return FooterChecksum::validateFooterSecurityFile();
            }
        }
        return true; // Checksum dosyası yoksa devam et
    }
    
    private static function validateSecurity() {
        // Anahtar kontrolü
        $key = base64_decode(self::$footerKey);
        if ($key !== '1687345291') {
            return false;
        }
        
        // Dosya varlık kontrolü
        if (!file_exists(__FILE__)) {
            return false;
        }
        
        return true;
    }
    
    private static function checkFileModification() {
        // Dosya boyut kontrolü
        $fileSize = filesize(__FILE__);
        if ($fileSize < 2000 || $fileSize > 10000) {
            return false; // Şüpheli dosya boyutu
        }
        
        // Son değişiklik tarihi kontrolü (çok yakın tarihse şüpheli)
        $lastModified = filemtime(__FILE__);
        $currentTime = time();
        if (($currentTime - $lastModified) < 300) { // 5 dakika
            // return false; // Geliştirme aşamasında devre dışı
        }
        
        return true;
    }
    
    private static function validateMultipleKeys() {
        // Çoklu anahtar doğrulama
        $keys = [
            base64_decode(self::$validationKeys['primary']),
            base64_decode(self::$validationKeys['secondary']),
            base64_decode(self::$validationKeys['tertiary'])
        ];
        
        $expectedKeys = [
            'Cursor-AI-Footer-Security',
            'MetinPaylas-Protected',
            'Footer-Guvenlik-Sistemi'
        ];
        
        return ($keys === $expectedKeys);
    }
    
    private static function runtimeSecurityCheck() {
        // Runtime sırasında ek kontroller
        
        // 1. Sınıf yapısı kontrolü
        if (!method_exists(__CLASS__, 'renderFooter')) {
            return false;
        }
        
        // 2. Sabit değer kontrolü
        $testHash = hash('sha256', 'test');
        if (strlen($testHash) !== 64) {
            return false; // Hash fonksiyonu çalışmıyor
        }
        
        // 3. Base64 fonksiyon kontrolü
        $testEncode = base64_encode('test');
        if (base64_decode($testEncode) !== 'test') {
            return false; // Base64 fonksiyonları çalışmıyor
        }
        
        return true;
    }
    
    private static function checkFileIntegrity() {
        // Bu dosyanın hash kontrolü
        $fileContent = file_get_contents(__FILE__);
        
        // Kritik sınıf ve metodların varlığını kontrol et
        $requiredElements = [
            'class FooterSecurity',
            'renderFooter',
            'validateSecurity',
            'checkFileModification',
            'validateMultipleKeys',
            'runtimeSecurityCheck'
        ];
        
        foreach ($requiredElements as $element) {
            if (strpos($fileContent, $element) === false) {
                return false;
            }
        }
        
        // Dosya içinde şüpheli kod var mı kontrol et
        $suspiciousPatterns = [
            'eval(',
            'exec(',
            'shell_exec(',
            'system(',
            'passthru(',
            'file_put_contents(',
            'fwrite(',
            'fputs('
        ];
        
        foreach ($suspiciousPatterns as $pattern) {
            if (strpos($fileContent, $pattern) !== false) {
                return false; // Şüpheli kod tespit edildi
            }
        }
        
        return true;
    }
    
    private static function getEmergencyFooter() {
        return '<footer class="border-top mt-5 py-4 text-center" style="background: var(--bg-card); border-color: var(--border-color) !important; color: var(--text-color);">
                    <div class="container">
                        <div class="row align-items-center">
                            <div class="col-md-4 text-start">
                                <small>&copy; 2024 MetinPaylaş. Tüm hakları saklıdır.</small>
                            </div>
                            <div class="col-md-4 text-center">
                                <small style="color: var(--text-secondary);">
                                    <i class="bi bi-code-slash me-1"></i>
                                    Geliştirildi: <a href="https://igtols.store" target="_blank" style="color: var(--primary-color); font-weight: bold; text-decoration: none;">Limon</a>
                                </small>
                            </div>
                            <div class="col-md-4 text-end">
                                <small>
                                    <a href="https://www.r10.net/profil/188334-limoncuyum.html" target="_blank" style="color: var(--primary-color); text-decoration: none;">
                                        <i class="bi bi-person-circle me-1"></i>R10 Profil
                                    </a>
                                </small>
                            </div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-12">
                                <small style="color: var(--text-secondary); font-size: 0.75rem;">
                                    Bu açık kaynak projedir. Lütfen footer\'ı değiştirmeyin ve geliştiriciyi destekleyin.
                                    <span class="mx-2">|</span>
                                    <a href="https://wa.me/905519261315" target="_blank" style="color: var(--primary-color); text-decoration: none;">
                                        <i class="bi bi-whatsapp me-1"></i>WhatsApp Destek
                                    </a>
                                </small>
                            </div>
                        </div>
                    </div>
                </footer>';
    }
}

// Sınıf dışından erişimi engelle
if (!defined('FOOTER_SECURITY_ALLOWED')) {
    die('Yetkisiz erişim!');
}
?>
